package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SrcNxNsiCaseBuilder} instances.
 *
 * @see SrcNxNsiCaseBuilder
 *
 */
public class SrcNxNsiCaseBuilder implements Builder<SrcNxNsiCase> {

    private Boolean _nxNsiDst;


    Map<Class<? extends Augmentation<SrcNxNsiCase>>, Augmentation<SrcNxNsiCase>> augmentation = Collections.emptyMap();

    public SrcNxNsiCaseBuilder() {
    }
    public SrcNxNsiCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNsiGrouping arg) {
        this._nxNsiDst = arg.isNxNsiDst();
    }

    public SrcNxNsiCaseBuilder(SrcNxNsiCase base) {
        this._nxNsiDst = base.isNxNsiDst();
        if (base instanceof SrcNxNsiCaseImpl) {
            SrcNxNsiCaseImpl impl = (SrcNxNsiCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SrcNxNsiCase>>, Augmentation<SrcNxNsiCase>> aug =((AugmentationHolder<SrcNxNsiCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNsiGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNsiGrouping) {
            this._nxNsiDst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNsiGrouping)arg).isNxNsiDst();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNsiGrouping]");
    }

    public Boolean isNxNsiDst() {
        return _nxNsiDst;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SrcNxNsiCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcNxNsiCaseBuilder setNxNsiDst(final Boolean value) {
        this._nxNsiDst = value;
        return this;
    }
    
    public SrcNxNsiCaseBuilder addAugmentation(Class<? extends Augmentation<SrcNxNsiCase>> augmentationType, Augmentation<SrcNxNsiCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcNxNsiCaseBuilder removeAugmentation(Class<? extends Augmentation<SrcNxNsiCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcNxNsiCase build() {
        return new SrcNxNsiCaseImpl(this);
    }

    private static final class SrcNxNsiCaseImpl implements SrcNxNsiCase {
    
        private final Boolean _nxNsiDst;
    
        private Map<Class<? extends Augmentation<SrcNxNsiCase>>, Augmentation<SrcNxNsiCase>> augmentation = Collections.emptyMap();
    
        SrcNxNsiCaseImpl(SrcNxNsiCaseBuilder base) {
            this._nxNsiDst = base.isNxNsiDst();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<SrcNxNsiCase> getImplementedInterface() {
            return SrcNxNsiCase.class;
        }
    
        @Override
        public Boolean isNxNsiDst() {
            return _nxNsiDst;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<SrcNxNsiCase>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxNsiDst);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcNxNsiCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SrcNxNsiCase other = (SrcNxNsiCase)obj;
            if (!Objects.equals(_nxNsiDst, other.isNxNsiDst())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcNxNsiCaseImpl otherImpl = (SrcNxNsiCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcNxNsiCase>>, Augmentation<SrcNxNsiCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcNxNsiCase");
            CodeHelpers.appendValue(helper, "_nxNsiDst", _nxNsiDst);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
