package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.remove.flow.input.instructions.instruction.instruction.write.actions._case.write.actions.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.decap.grouping.NxDecap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionDecapRpcRemoveFlowWriteActionsCaseBuilder} instances.
 *
 * @see NxActionDecapRpcRemoveFlowWriteActionsCaseBuilder
 *
 */
public class NxActionDecapRpcRemoveFlowWriteActionsCaseBuilder implements Builder<NxActionDecapRpcRemoveFlowWriteActionsCase> {

    private NxDecap _nxDecap;


    Map<Class<? extends Augmentation<NxActionDecapRpcRemoveFlowWriteActionsCase>>, Augmentation<NxActionDecapRpcRemoveFlowWriteActionsCase>> augmentation = Collections.emptyMap();

    public NxActionDecapRpcRemoveFlowWriteActionsCaseBuilder() {
    }
    public NxActionDecapRpcRemoveFlowWriteActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecapGrouping arg) {
        this._nxDecap = arg.getNxDecap();
    }

    public NxActionDecapRpcRemoveFlowWriteActionsCaseBuilder(NxActionDecapRpcRemoveFlowWriteActionsCase base) {
        this._nxDecap = base.getNxDecap();
        if (base instanceof NxActionDecapRpcRemoveFlowWriteActionsCaseImpl) {
            NxActionDecapRpcRemoveFlowWriteActionsCaseImpl impl = (NxActionDecapRpcRemoveFlowWriteActionsCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionDecapRpcRemoveFlowWriteActionsCase>>, Augmentation<NxActionDecapRpcRemoveFlowWriteActionsCase>> aug =((AugmentationHolder<NxActionDecapRpcRemoveFlowWriteActionsCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecapGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecapGrouping) {
            this._nxDecap = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecapGrouping)arg).getNxDecap();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecapGrouping]");
    }

    public NxDecap getNxDecap() {
        return _nxDecap;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionDecapRpcRemoveFlowWriteActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionDecapRpcRemoveFlowWriteActionsCaseBuilder setNxDecap(final NxDecap value) {
        this._nxDecap = value;
        return this;
    }
    
    public NxActionDecapRpcRemoveFlowWriteActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionDecapRpcRemoveFlowWriteActionsCase>> augmentationType, Augmentation<NxActionDecapRpcRemoveFlowWriteActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionDecapRpcRemoveFlowWriteActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionDecapRpcRemoveFlowWriteActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionDecapRpcRemoveFlowWriteActionsCase build() {
        return new NxActionDecapRpcRemoveFlowWriteActionsCaseImpl(this);
    }

    private static final class NxActionDecapRpcRemoveFlowWriteActionsCaseImpl implements NxActionDecapRpcRemoveFlowWriteActionsCase {
    
        private final NxDecap _nxDecap;
    
        private Map<Class<? extends Augmentation<NxActionDecapRpcRemoveFlowWriteActionsCase>>, Augmentation<NxActionDecapRpcRemoveFlowWriteActionsCase>> augmentation = Collections.emptyMap();
    
        NxActionDecapRpcRemoveFlowWriteActionsCaseImpl(NxActionDecapRpcRemoveFlowWriteActionsCaseBuilder base) {
            this._nxDecap = base.getNxDecap();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionDecapRpcRemoveFlowWriteActionsCase> getImplementedInterface() {
            return NxActionDecapRpcRemoveFlowWriteActionsCase.class;
        }
    
        @Override
        public NxDecap getNxDecap() {
            return _nxDecap;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<NxActionDecapRpcRemoveFlowWriteActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxDecap);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionDecapRpcRemoveFlowWriteActionsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionDecapRpcRemoveFlowWriteActionsCase other = (NxActionDecapRpcRemoveFlowWriteActionsCase)obj;
            if (!Objects.equals(_nxDecap, other.getNxDecap())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionDecapRpcRemoveFlowWriteActionsCaseImpl otherImpl = (NxActionDecapRpcRemoveFlowWriteActionsCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionDecapRpcRemoveFlowWriteActionsCase>>, Augmentation<NxActionDecapRpcRemoveFlowWriteActionsCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionDecapRpcRemoveFlowWriteActionsCase");
            CodeHelpers.appendValue(helper, "_nxDecap", _nxDecap);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
