package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.get.flow.statistics.output.flow.and.statistics.map.list.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.dec.nsh.ttl.grouping.NxDecNshTtl;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCaseBuilder} instances.
 *
 * @see NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCaseBuilder
 *
 */
public class NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCaseBuilder implements Builder<NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCase> {

    private NxDecNshTtl _nxDecNshTtl;


    Map<Class<? extends Augmentation<NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCase>> augmentation = Collections.emptyMap();

    public NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCaseBuilder() {
    }
    public NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecNshTtlGrouping arg) {
        this._nxDecNshTtl = arg.getNxDecNshTtl();
    }

    public NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCaseBuilder(NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCase base) {
        this._nxDecNshTtl = base.getNxDecNshTtl();
        if (base instanceof NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCaseImpl) {
            NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCaseImpl impl = (NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCase>> aug =((AugmentationHolder<NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecNshTtlGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecNshTtlGrouping) {
            this._nxDecNshTtl = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecNshTtlGrouping)arg).getNxDecNshTtl();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecNshTtlGrouping]");
    }

    public NxDecNshTtl getNxDecNshTtl() {
        return _nxDecNshTtl;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCaseBuilder setNxDecNshTtl(final NxDecNshTtl value) {
        this._nxDecNshTtl = value;
        return this;
    }
    
    public NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCase>> augmentationType, Augmentation<NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCase build() {
        return new NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCaseImpl(this);
    }

    private static final class NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCaseImpl implements NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCase {
    
        private final NxDecNshTtl _nxDecNshTtl;
    
        private Map<Class<? extends Augmentation<NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCase>> augmentation = Collections.emptyMap();
    
        NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCaseImpl(NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCaseBuilder base) {
            this._nxDecNshTtl = base.getNxDecNshTtl();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCase> getImplementedInterface() {
            return NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCase.class;
        }
    
        @Override
        public NxDecNshTtl getNxDecNshTtl() {
            return _nxDecNshTtl;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxDecNshTtl);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCase other = (NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCase)obj;
            if (!Objects.equals(_nxDecNshTtl, other.getNxDecNshTtl())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCaseImpl otherImpl = (NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionDecNshTtlNotifDirectStatisticsUpdateApplyActionsCase");
            CodeHelpers.appendValue(helper, "_nxDecNshTtl", _nxDecNshTtl);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
