package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec.flow.mod.output.to.port._case.FlowModOutputToPort;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link FlowModOutputToPortCaseBuilder} instances.
 *
 * @see FlowModOutputToPortCaseBuilder
 *
 */
public class FlowModOutputToPortCaseBuilder implements Builder<FlowModOutputToPortCase> {

    private FlowModOutputToPort _flowModOutputToPort;


    Map<Class<? extends Augmentation<FlowModOutputToPortCase>>, Augmentation<FlowModOutputToPortCase>> augmentation = Collections.emptyMap();

    public FlowModOutputToPortCaseBuilder() {
    }

    public FlowModOutputToPortCaseBuilder(FlowModOutputToPortCase base) {
        this._flowModOutputToPort = base.getFlowModOutputToPort();
        if (base instanceof FlowModOutputToPortCaseImpl) {
            FlowModOutputToPortCaseImpl impl = (FlowModOutputToPortCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<FlowModOutputToPortCase>>, Augmentation<FlowModOutputToPortCase>> aug =((AugmentationHolder<FlowModOutputToPortCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    public FlowModOutputToPort getFlowModOutputToPort() {
        return _flowModOutputToPort;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<FlowModOutputToPortCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public FlowModOutputToPortCaseBuilder setFlowModOutputToPort(final FlowModOutputToPort value) {
        this._flowModOutputToPort = value;
        return this;
    }
    
    public FlowModOutputToPortCaseBuilder addAugmentation(Class<? extends Augmentation<FlowModOutputToPortCase>> augmentationType, Augmentation<FlowModOutputToPortCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public FlowModOutputToPortCaseBuilder removeAugmentation(Class<? extends Augmentation<FlowModOutputToPortCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public FlowModOutputToPortCase build() {
        return new FlowModOutputToPortCaseImpl(this);
    }

    private static final class FlowModOutputToPortCaseImpl implements FlowModOutputToPortCase {
    
        private final FlowModOutputToPort _flowModOutputToPort;
    
        private Map<Class<? extends Augmentation<FlowModOutputToPortCase>>, Augmentation<FlowModOutputToPortCase>> augmentation = Collections.emptyMap();
    
        FlowModOutputToPortCaseImpl(FlowModOutputToPortCaseBuilder base) {
            this._flowModOutputToPort = base.getFlowModOutputToPort();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<FlowModOutputToPortCase> getImplementedInterface() {
            return FlowModOutputToPortCase.class;
        }
    
        @Override
        public FlowModOutputToPort getFlowModOutputToPort() {
            return _flowModOutputToPort;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<FlowModOutputToPortCase>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_flowModOutputToPort);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowModOutputToPortCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            FlowModOutputToPortCase other = (FlowModOutputToPortCase)obj;
            if (!Objects.equals(_flowModOutputToPort, other.getFlowModOutputToPort())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                FlowModOutputToPortCaseImpl otherImpl = (FlowModOutputToPortCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<FlowModOutputToPortCase>>, Augmentation<FlowModOutputToPortCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("FlowModOutputToPortCase");
            CodeHelpers.appendValue(helper, "_flowModOutputToPort", _flowModOutputToPort);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
