package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.dst.choice;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link DstNxNshc3CaseBuilder} instances.
 *
 * @see DstNxNshc3CaseBuilder
 *
 */
public class DstNxNshc3CaseBuilder implements Builder<DstNxNshc3Case> {

    private Boolean _nxNshc3Dst;


    Map<Class<? extends Augmentation<DstNxNshc3Case>>, Augmentation<DstNxNshc3Case>> augmentation = Collections.emptyMap();

    public DstNxNshc3CaseBuilder() {
    }
    public DstNxNshc3CaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc3Grouping arg) {
        this._nxNshc3Dst = arg.isNxNshc3Dst();
    }

    public DstNxNshc3CaseBuilder(DstNxNshc3Case base) {
        this._nxNshc3Dst = base.isNxNshc3Dst();
        if (base instanceof DstNxNshc3CaseImpl) {
            DstNxNshc3CaseImpl impl = (DstNxNshc3CaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<DstNxNshc3Case>>, Augmentation<DstNxNshc3Case>> aug =((AugmentationHolder<DstNxNshc3Case>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc3Grouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc3Grouping) {
            this._nxNshc3Dst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc3Grouping)arg).isNxNshc3Dst();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc3Grouping]");
    }

    public Boolean isNxNshc3Dst() {
        return _nxNshc3Dst;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<DstNxNshc3Case>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DstNxNshc3CaseBuilder setNxNshc3Dst(final Boolean value) {
        this._nxNshc3Dst = value;
        return this;
    }
    
    public DstNxNshc3CaseBuilder addAugmentation(Class<? extends Augmentation<DstNxNshc3Case>> augmentationType, Augmentation<DstNxNshc3Case> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DstNxNshc3CaseBuilder removeAugmentation(Class<? extends Augmentation<DstNxNshc3Case>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DstNxNshc3Case build() {
        return new DstNxNshc3CaseImpl(this);
    }

    private static final class DstNxNshc3CaseImpl implements DstNxNshc3Case {
    
        private final Boolean _nxNshc3Dst;
    
        private Map<Class<? extends Augmentation<DstNxNshc3Case>>, Augmentation<DstNxNshc3Case>> augmentation = Collections.emptyMap();
    
        DstNxNshc3CaseImpl(DstNxNshc3CaseBuilder base) {
            this._nxNshc3Dst = base.isNxNshc3Dst();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<DstNxNshc3Case> getImplementedInterface() {
            return DstNxNshc3Case.class;
        }
    
        @Override
        public Boolean isNxNshc3Dst() {
            return _nxNshc3Dst;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<DstNxNshc3Case>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxNshc3Dst);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DstNxNshc3Case.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DstNxNshc3Case other = (DstNxNshc3Case)obj;
            if (!Objects.equals(_nxNshc3Dst, other.isNxNshc3Dst())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DstNxNshc3CaseImpl otherImpl = (DstNxNshc3CaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DstNxNshc3Case>>, Augmentation<DstNxNshc3Case>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DstNxNshc3Case");
            CodeHelpers.appendValue(helper, "_nxNshc3Dst", _nxNshc3Dst);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
