package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.dst.choice;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link DstNxArpThaCaseBuilder} instances.
 *
 * @see DstNxArpThaCaseBuilder
 *
 */
public class DstNxArpThaCaseBuilder implements Builder<DstNxArpThaCase> {

    private Boolean _nxArpTha;


    Map<Class<? extends Augmentation<DstNxArpThaCase>>, Augmentation<DstNxArpThaCase>> augmentation = Collections.emptyMap();

    public DstNxArpThaCaseBuilder() {
    }
    public DstNxArpThaCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxArpThaGrouping arg) {
        this._nxArpTha = arg.isNxArpTha();
    }

    public DstNxArpThaCaseBuilder(DstNxArpThaCase base) {
        this._nxArpTha = base.isNxArpTha();
        if (base instanceof DstNxArpThaCaseImpl) {
            DstNxArpThaCaseImpl impl = (DstNxArpThaCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<DstNxArpThaCase>>, Augmentation<DstNxArpThaCase>> aug =((AugmentationHolder<DstNxArpThaCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxArpThaGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxArpThaGrouping) {
            this._nxArpTha = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxArpThaGrouping)arg).isNxArpTha();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxArpThaGrouping]");
    }

    public Boolean isNxArpTha() {
        return _nxArpTha;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<DstNxArpThaCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DstNxArpThaCaseBuilder setNxArpTha(final Boolean value) {
        this._nxArpTha = value;
        return this;
    }
    
    public DstNxArpThaCaseBuilder addAugmentation(Class<? extends Augmentation<DstNxArpThaCase>> augmentationType, Augmentation<DstNxArpThaCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DstNxArpThaCaseBuilder removeAugmentation(Class<? extends Augmentation<DstNxArpThaCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DstNxArpThaCase build() {
        return new DstNxArpThaCaseImpl(this);
    }

    private static final class DstNxArpThaCaseImpl implements DstNxArpThaCase {
    
        private final Boolean _nxArpTha;
    
        private Map<Class<? extends Augmentation<DstNxArpThaCase>>, Augmentation<DstNxArpThaCase>> augmentation = Collections.emptyMap();
    
        DstNxArpThaCaseImpl(DstNxArpThaCaseBuilder base) {
            this._nxArpTha = base.isNxArpTha();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<DstNxArpThaCase> getImplementedInterface() {
            return DstNxArpThaCase.class;
        }
    
        @Override
        public Boolean isNxArpTha() {
            return _nxArpTha;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<DstNxArpThaCase>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxArpTha);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DstNxArpThaCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DstNxArpThaCase other = (DstNxArpThaCase)obj;
            if (!Objects.equals(_nxArpTha, other.isNxArpTha())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DstNxArpThaCaseImpl otherImpl = (DstNxArpThaCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DstNxArpThaCase>>, Augmentation<DstNxArpThaCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DstNxArpThaCase");
            CodeHelpers.appendValue(helper, "_nxArpTha", _nxArpTha);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
