package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.ip.src.grouping;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxmOfIpSrcBuilder} instances.
 *
 * @see NxmOfIpSrcBuilder
 *
 */
public class NxmOfIpSrcBuilder implements Builder<NxmOfIpSrc> {

    private Ipv4Address _ipv4Address;


    Map<Class<? extends Augmentation<NxmOfIpSrc>>, Augmentation<NxmOfIpSrc>> augmentation = Collections.emptyMap();

    public NxmOfIpSrcBuilder() {
    }
    public NxmOfIpSrcBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.Ipv4AddressGrouping arg) {
        this._ipv4Address = arg.getIpv4Address();
    }

    public NxmOfIpSrcBuilder(NxmOfIpSrc base) {
        this._ipv4Address = base.getIpv4Address();
        if (base instanceof NxmOfIpSrcImpl) {
            NxmOfIpSrcImpl impl = (NxmOfIpSrcImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<NxmOfIpSrc> casted =(AugmentationHolder<NxmOfIpSrc>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.Ipv4AddressGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.Ipv4AddressGrouping) {
            this._ipv4Address = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.Ipv4AddressGrouping)arg).getIpv4Address();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.Ipv4AddressGrouping]");
    }

    public Ipv4Address getIpv4Address() {
        return _ipv4Address;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxmOfIpSrc>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxmOfIpSrcBuilder setIpv4Address(final Ipv4Address value) {
        this._ipv4Address = value;
        return this;
    }
    
    public NxmOfIpSrcBuilder addAugmentation(Class<? extends Augmentation<NxmOfIpSrc>> augmentationType, Augmentation<NxmOfIpSrc> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxmOfIpSrcBuilder removeAugmentation(Class<? extends Augmentation<NxmOfIpSrc>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxmOfIpSrc build() {
        return new NxmOfIpSrcImpl(this);
    }

    private static final class NxmOfIpSrcImpl implements NxmOfIpSrc {
    
        private final Ipv4Address _ipv4Address;
    
        private Map<Class<? extends Augmentation<NxmOfIpSrc>>, Augmentation<NxmOfIpSrc>> augmentation = Collections.emptyMap();
    
        private NxmOfIpSrcImpl(NxmOfIpSrcBuilder base) {
            this._ipv4Address = base.getIpv4Address();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxmOfIpSrc> getImplementedInterface() {
            return NxmOfIpSrc.class;
        }
    
        @Override
        public Ipv4Address getIpv4Address() {
            return _ipv4Address;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxmOfIpSrc>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ipv4Address);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmOfIpSrc.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxmOfIpSrc other = (NxmOfIpSrc)obj;
            if (!Objects.equals(_ipv4Address, other.getIpv4Address())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxmOfIpSrcImpl otherImpl = (NxmOfIpSrcImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxmOfIpSrc>>, Augmentation<NxmOfIpSrc>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxmOfIpSrc");
            CodeHelpers.appendValue(helper, "_ipv4Address", _ipv4Address);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
