package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.update.group.input.updated.group.buckets.bucket.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.encap.grouping.NxEncap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionEncapRpcUpdateGroupUpdatedCaseBuilder} instances.
 *
 * @see NxActionEncapRpcUpdateGroupUpdatedCaseBuilder
 *
 */
public class NxActionEncapRpcUpdateGroupUpdatedCaseBuilder implements Builder<NxActionEncapRpcUpdateGroupUpdatedCase> {

    private NxEncap _nxEncap;


    Map<Class<? extends Augmentation<NxActionEncapRpcUpdateGroupUpdatedCase>>, Augmentation<NxActionEncapRpcUpdateGroupUpdatedCase>> augmentation = Collections.emptyMap();

    public NxActionEncapRpcUpdateGroupUpdatedCaseBuilder() {
    }
    public NxActionEncapRpcUpdateGroupUpdatedCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping arg) {
        this._nxEncap = arg.getNxEncap();
    }

    public NxActionEncapRpcUpdateGroupUpdatedCaseBuilder(NxActionEncapRpcUpdateGroupUpdatedCase base) {
        this._nxEncap = base.getNxEncap();
        if (base instanceof NxActionEncapRpcUpdateGroupUpdatedCaseImpl) {
            NxActionEncapRpcUpdateGroupUpdatedCaseImpl impl = (NxActionEncapRpcUpdateGroupUpdatedCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<NxActionEncapRpcUpdateGroupUpdatedCase> casted =(AugmentationHolder<NxActionEncapRpcUpdateGroupUpdatedCase>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping) {
            this._nxEncap = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping)arg).getNxEncap();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping]");
    }

    public NxEncap getNxEncap() {
        return _nxEncap;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxActionEncapRpcUpdateGroupUpdatedCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionEncapRpcUpdateGroupUpdatedCaseBuilder setNxEncap(final NxEncap value) {
        this._nxEncap = value;
        return this;
    }
    
    public NxActionEncapRpcUpdateGroupUpdatedCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionEncapRpcUpdateGroupUpdatedCase>> augmentationType, Augmentation<NxActionEncapRpcUpdateGroupUpdatedCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionEncapRpcUpdateGroupUpdatedCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionEncapRpcUpdateGroupUpdatedCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionEncapRpcUpdateGroupUpdatedCase build() {
        return new NxActionEncapRpcUpdateGroupUpdatedCaseImpl(this);
    }

    private static final class NxActionEncapRpcUpdateGroupUpdatedCaseImpl implements NxActionEncapRpcUpdateGroupUpdatedCase {
    
        private final NxEncap _nxEncap;
    
        private Map<Class<? extends Augmentation<NxActionEncapRpcUpdateGroupUpdatedCase>>, Augmentation<NxActionEncapRpcUpdateGroupUpdatedCase>> augmentation = Collections.emptyMap();
    
        private NxActionEncapRpcUpdateGroupUpdatedCaseImpl(NxActionEncapRpcUpdateGroupUpdatedCaseBuilder base) {
            this._nxEncap = base.getNxEncap();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionEncapRpcUpdateGroupUpdatedCase> getImplementedInterface() {
            return NxActionEncapRpcUpdateGroupUpdatedCase.class;
        }
    
        @Override
        public NxEncap getNxEncap() {
            return _nxEncap;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxActionEncapRpcUpdateGroupUpdatedCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxEncap);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionEncapRpcUpdateGroupUpdatedCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionEncapRpcUpdateGroupUpdatedCase other = (NxActionEncapRpcUpdateGroupUpdatedCase)obj;
            if (!Objects.equals(_nxEncap, other.getNxEncap())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionEncapRpcUpdateGroupUpdatedCaseImpl otherImpl = (NxActionEncapRpcUpdateGroupUpdatedCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionEncapRpcUpdateGroupUpdatedCase>>, Augmentation<NxActionEncapRpcUpdateGroupUpdatedCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionEncapRpcUpdateGroupUpdatedCase");
            CodeHelpers.appendValue(helper, "_nxEncap", _nxEncap);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
