package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.update.flow.input.original.flow.instructions.instruction.instruction.write.actions._case.write.actions.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.encap.grouping.NxEncap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder} instances.
 *
 * @see NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder
 *
 */
public class NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder implements Builder<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase> {

    private NxEncap _nxEncap;


    Map<Class<? extends Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>>, Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>> augmentation = Collections.emptyMap();

    public NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder() {
    }
    public NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping arg) {
        this._nxEncap = arg.getNxEncap();
    }

    public NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder(NxActionEncapRpcUpdateFlowOriginalWriteActionsCase base) {
        this._nxEncap = base.getNxEncap();
        if (base instanceof NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseImpl) {
            NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseImpl impl = (NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase> casted =(AugmentationHolder<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping) {
            this._nxEncap = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping)arg).getNxEncap();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping]");
    }

    public NxEncap getNxEncap() {
        return _nxEncap;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder setNxEncap(final NxEncap value) {
        this._nxEncap = value;
        return this;
    }
    
    public NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>> augmentationType, Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionEncapRpcUpdateFlowOriginalWriteActionsCase build() {
        return new NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseImpl(this);
    }

    private static final class NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseImpl implements NxActionEncapRpcUpdateFlowOriginalWriteActionsCase {
    
        private final NxEncap _nxEncap;
    
        private Map<Class<? extends Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>>, Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>> augmentation = Collections.emptyMap();
    
        private NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseImpl(NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder base) {
            this._nxEncap = base.getNxEncap();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase> getImplementedInterface() {
            return NxActionEncapRpcUpdateFlowOriginalWriteActionsCase.class;
        }
    
        @Override
        public NxEncap getNxEncap() {
            return _nxEncap;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxEncap);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionEncapRpcUpdateFlowOriginalWriteActionsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionEncapRpcUpdateFlowOriginalWriteActionsCase other = (NxActionEncapRpcUpdateFlowOriginalWriteActionsCase)obj;
            if (!Objects.equals(_nxEncap, other.getNxEncap())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseImpl otherImpl = (NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>>, Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionEncapRpcUpdateFlowOriginalWriteActionsCase");
            CodeHelpers.appendValue(helper, "_nxEncap", _nxEncap);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
