package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SrcNxNshc2CaseBuilder} instances.
 *
 * @see SrcNxNshc2CaseBuilder
 *
 */
public class SrcNxNshc2CaseBuilder implements Builder<SrcNxNshc2Case> {

    private Boolean _nxNshc2Dst;


    Map<Class<? extends Augmentation<SrcNxNshc2Case>>, Augmentation<SrcNxNshc2Case>> augmentation = Collections.emptyMap();

    public SrcNxNshc2CaseBuilder() {
    }
    public SrcNxNshc2CaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc2Grouping arg) {
        this._nxNshc2Dst = arg.isNxNshc2Dst();
    }

    public SrcNxNshc2CaseBuilder(SrcNxNshc2Case base) {
        this._nxNshc2Dst = base.isNxNshc2Dst();
        if (base instanceof SrcNxNshc2CaseImpl) {
            SrcNxNshc2CaseImpl impl = (SrcNxNshc2CaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<SrcNxNshc2Case> casted =(AugmentationHolder<SrcNxNshc2Case>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc2Grouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc2Grouping) {
            this._nxNshc2Dst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc2Grouping)arg).isNxNshc2Dst();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc2Grouping]");
    }

    public Boolean isNxNshc2Dst() {
        return _nxNshc2Dst;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<SrcNxNshc2Case>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcNxNshc2CaseBuilder setNxNshc2Dst(final Boolean value) {
        this._nxNshc2Dst = value;
        return this;
    }
    
    public SrcNxNshc2CaseBuilder addAugmentation(Class<? extends Augmentation<SrcNxNshc2Case>> augmentationType, Augmentation<SrcNxNshc2Case> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcNxNshc2CaseBuilder removeAugmentation(Class<? extends Augmentation<SrcNxNshc2Case>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcNxNshc2Case build() {
        return new SrcNxNshc2CaseImpl(this);
    }

    private static final class SrcNxNshc2CaseImpl implements SrcNxNshc2Case {
    
        private final Boolean _nxNshc2Dst;
    
        private Map<Class<? extends Augmentation<SrcNxNshc2Case>>, Augmentation<SrcNxNshc2Case>> augmentation = Collections.emptyMap();
    
        private SrcNxNshc2CaseImpl(SrcNxNshc2CaseBuilder base) {
            this._nxNshc2Dst = base.isNxNshc2Dst();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<SrcNxNshc2Case> getImplementedInterface() {
            return SrcNxNshc2Case.class;
        }
    
        @Override
        public Boolean isNxNshc2Dst() {
            return _nxNshc2Dst;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<SrcNxNshc2Case>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxNshc2Dst);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcNxNshc2Case.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SrcNxNshc2Case other = (SrcNxNshc2Case)obj;
            if (!Objects.equals(_nxNshc2Dst, other.isNxNshc2Dst())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcNxNshc2CaseImpl otherImpl = (SrcNxNshc2CaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcNxNshc2Case>>, Augmentation<SrcNxNshc2Case>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcNxNshc2Case");
            CodeHelpers.appendValue(helper, "_nxNshc2Dst", _nxNshc2Dst);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
