package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.remove.group.input.buckets.bucket.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.load.grouping.NxRegLoad;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionRegLoadRpcRemoveGroupCaseBuilder} instances.
 *
 * @see NxActionRegLoadRpcRemoveGroupCaseBuilder
 *
 */
public class NxActionRegLoadRpcRemoveGroupCaseBuilder implements Builder<NxActionRegLoadRpcRemoveGroupCase> {

    private NxRegLoad _nxRegLoad;


    Map<Class<? extends Augmentation<NxActionRegLoadRpcRemoveGroupCase>>, Augmentation<NxActionRegLoadRpcRemoveGroupCase>> augmentation = Collections.emptyMap();

    public NxActionRegLoadRpcRemoveGroupCaseBuilder() {
    }
    public NxActionRegLoadRpcRemoveGroupCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegLoadGrouping arg) {
        this._nxRegLoad = arg.getNxRegLoad();
    }

    public NxActionRegLoadRpcRemoveGroupCaseBuilder(NxActionRegLoadRpcRemoveGroupCase base) {
        this._nxRegLoad = base.getNxRegLoad();
        if (base instanceof NxActionRegLoadRpcRemoveGroupCaseImpl) {
            NxActionRegLoadRpcRemoveGroupCaseImpl impl = (NxActionRegLoadRpcRemoveGroupCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<NxActionRegLoadRpcRemoveGroupCase> casted =(AugmentationHolder<NxActionRegLoadRpcRemoveGroupCase>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegLoadGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegLoadGrouping) {
            this._nxRegLoad = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegLoadGrouping)arg).getNxRegLoad();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegLoadGrouping]");
    }

    public NxRegLoad getNxRegLoad() {
        return _nxRegLoad;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxActionRegLoadRpcRemoveGroupCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionRegLoadRpcRemoveGroupCaseBuilder setNxRegLoad(final NxRegLoad value) {
        this._nxRegLoad = value;
        return this;
    }
    
    public NxActionRegLoadRpcRemoveGroupCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionRegLoadRpcRemoveGroupCase>> augmentationType, Augmentation<NxActionRegLoadRpcRemoveGroupCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionRegLoadRpcRemoveGroupCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionRegLoadRpcRemoveGroupCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionRegLoadRpcRemoveGroupCase build() {
        return new NxActionRegLoadRpcRemoveGroupCaseImpl(this);
    }

    private static final class NxActionRegLoadRpcRemoveGroupCaseImpl implements NxActionRegLoadRpcRemoveGroupCase {
    
        private final NxRegLoad _nxRegLoad;
    
        private Map<Class<? extends Augmentation<NxActionRegLoadRpcRemoveGroupCase>>, Augmentation<NxActionRegLoadRpcRemoveGroupCase>> augmentation = Collections.emptyMap();
    
        private NxActionRegLoadRpcRemoveGroupCaseImpl(NxActionRegLoadRpcRemoveGroupCaseBuilder base) {
            this._nxRegLoad = base.getNxRegLoad();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionRegLoadRpcRemoveGroupCase> getImplementedInterface() {
            return NxActionRegLoadRpcRemoveGroupCase.class;
        }
    
        @Override
        public NxRegLoad getNxRegLoad() {
            return _nxRegLoad;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxActionRegLoadRpcRemoveGroupCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxRegLoad);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionRegLoadRpcRemoveGroupCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionRegLoadRpcRemoveGroupCase other = (NxActionRegLoadRpcRemoveGroupCase)obj;
            if (!Objects.equals(_nxRegLoad, other.getNxRegLoad())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionRegLoadRpcRemoveGroupCaseImpl otherImpl = (NxActionRegLoadRpcRemoveGroupCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionRegLoadRpcRemoveGroupCase>>, Augmentation<NxActionRegLoadRpcRemoveGroupCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionRegLoadRpcRemoveGroupCase");
            CodeHelpers.appendValue(helper, "_nxRegLoad", _nxRegLoad);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
