package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.ct.mark._case.NxActionCtMark;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionCtMarkCaseBuilder} instances.
 *
 * @see NxActionCtMarkCaseBuilder
 *
 */
public class NxActionCtMarkCaseBuilder implements Builder<NxActionCtMarkCase> {

    private NxActionCtMark _nxActionCtMark;


    Map<Class<? extends Augmentation<NxActionCtMarkCase>>, Augmentation<NxActionCtMarkCase>> augmentation = Collections.emptyMap();

    public NxActionCtMarkCaseBuilder() {
    }

    public NxActionCtMarkCaseBuilder(NxActionCtMarkCase base) {
        this._nxActionCtMark = base.getNxActionCtMark();
        if (base instanceof NxActionCtMarkCaseImpl) {
            NxActionCtMarkCaseImpl impl = (NxActionCtMarkCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<NxActionCtMarkCase> casted =(AugmentationHolder<NxActionCtMarkCase>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public NxActionCtMark getNxActionCtMark() {
        return _nxActionCtMark;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxActionCtMarkCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionCtMarkCaseBuilder setNxActionCtMark(final NxActionCtMark value) {
        this._nxActionCtMark = value;
        return this;
    }
    
    public NxActionCtMarkCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionCtMarkCase>> augmentationType, Augmentation<NxActionCtMarkCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionCtMarkCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionCtMarkCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionCtMarkCase build() {
        return new NxActionCtMarkCaseImpl(this);
    }

    private static final class NxActionCtMarkCaseImpl implements NxActionCtMarkCase {
    
        private final NxActionCtMark _nxActionCtMark;
    
        private Map<Class<? extends Augmentation<NxActionCtMarkCase>>, Augmentation<NxActionCtMarkCase>> augmentation = Collections.emptyMap();
    
        private NxActionCtMarkCaseImpl(NxActionCtMarkCaseBuilder base) {
            this._nxActionCtMark = base.getNxActionCtMark();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionCtMarkCase> getImplementedInterface() {
            return NxActionCtMarkCase.class;
        }
    
        @Override
        public NxActionCtMark getNxActionCtMark() {
            return _nxActionCtMark;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxActionCtMarkCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxActionCtMark);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionCtMarkCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionCtMarkCase other = (NxActionCtMarkCase)obj;
            if (!Objects.equals(_nxActionCtMark, other.getNxActionCtMark())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionCtMarkCaseImpl otherImpl = (NxActionCtMarkCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionCtMarkCase>>, Augmentation<NxActionCtMarkCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionCtMarkCase");
            CodeHelpers.appendValue(helper, "_nxActionCtMark", _nxActionCtMark);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
