package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.move.grouping;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.move.grouping.nx.reg.move.Dst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.move.grouping.nx.reg.move.Src;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxRegMoveBuilder} instances.
 *
 * @see NxRegMoveBuilder
 *
 */
public class NxRegMoveBuilder implements Builder<NxRegMove> {

    private Dst _dst;
    private Src _src;


    Map<Class<? extends Augmentation<NxRegMove>>, Augmentation<NxRegMove>> augmentation = Collections.emptyMap();

    public NxRegMoveBuilder() {
    }

    public NxRegMoveBuilder(NxRegMove base) {
        this._dst = base.getDst();
        this._src = base.getSrc();
        if (base instanceof NxRegMoveImpl) {
            NxRegMoveImpl impl = (NxRegMoveImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<NxRegMove> casted =(AugmentationHolder<NxRegMove>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public Dst getDst() {
        return _dst;
    }
    
    public Src getSrc() {
        return _src;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxRegMove>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxRegMoveBuilder setDst(final Dst value) {
        this._dst = value;
        return this;
    }
    
    public NxRegMoveBuilder setSrc(final Src value) {
        this._src = value;
        return this;
    }
    
    public NxRegMoveBuilder addAugmentation(Class<? extends Augmentation<NxRegMove>> augmentationType, Augmentation<NxRegMove> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxRegMoveBuilder removeAugmentation(Class<? extends Augmentation<NxRegMove>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxRegMove build() {
        return new NxRegMoveImpl(this);
    }

    private static final class NxRegMoveImpl implements NxRegMove {
    
        private final Dst _dst;
        private final Src _src;
    
        private Map<Class<? extends Augmentation<NxRegMove>>, Augmentation<NxRegMove>> augmentation = Collections.emptyMap();
    
        private NxRegMoveImpl(NxRegMoveBuilder base) {
            this._dst = base.getDst();
            this._src = base.getSrc();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxRegMove> getImplementedInterface() {
            return NxRegMove.class;
        }
    
        @Override
        public Dst getDst() {
            return _dst;
        }
        
        @Override
        public Src getSrc() {
            return _src;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxRegMove>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_dst);
            result = prime * result + Objects.hashCode(_src);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxRegMove.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxRegMove other = (NxRegMove)obj;
            if (!Objects.equals(_dst, other.getDst())) {
                return false;
            }
            if (!Objects.equals(_src, other.getSrc())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxRegMoveImpl otherImpl = (NxRegMoveImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxRegMove>>, Augmentation<NxRegMove>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxRegMove");
            CodeHelpers.appendValue(helper, "_dst", _dst);
            CodeHelpers.appendValue(helper, "_src", _src);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
