package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.load.grouping;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.load.grouping.nx.reg.load.Dst;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxRegLoadBuilder} instances.
 *
 * @see NxRegLoadBuilder
 *
 */
public class NxRegLoadBuilder implements Builder<NxRegLoad> {

    private Dst _dst;
    private BigInteger _value;


    Map<Class<? extends Augmentation<NxRegLoad>>, Augmentation<NxRegLoad>> augmentation = Collections.emptyMap();

    public NxRegLoadBuilder() {
    }

    public NxRegLoadBuilder(NxRegLoad base) {
        this._dst = base.getDst();
        this._value = base.getValue();
        if (base instanceof NxRegLoadImpl) {
            NxRegLoadImpl impl = (NxRegLoadImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<NxRegLoad> casted =(AugmentationHolder<NxRegLoad>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public Dst getDst() {
        return _dst;
    }
    
    public BigInteger getValue() {
        return _value;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxRegLoad>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxRegLoadBuilder setDst(final Dst value) {
        this._dst = value;
        return this;
    }
    private static final Range<java.math.BigInteger>[] CHECKVALUERANGE_RANGES;
    static {
        @SuppressWarnings("unchecked")
        final Range<java.math.BigInteger>[] a = (Range<java.math.BigInteger>[]) Array.newInstance(Range.class, 1);
        a[0] = Range.closed(java.math.BigInteger.ZERO, new java.math.BigInteger("18446744073709551615"));
        CHECKVALUERANGE_RANGES = a;
    }
    private static void checkValueRange(final java.math.BigInteger value) {
        for (Range<java.math.BigInteger> r : CHECKVALUERANGE_RANGES) {
            if (r.contains(value)) {
                return;
            }
        }
        CodeHelpers.throwInvalidRange(CHECKVALUERANGE_RANGES, value);
    }
    
    public NxRegLoadBuilder setValue(final BigInteger value) {
    if (value != null) {
        checkValueRange(value);
        
    }
        this._value = value;
        return this;
    }
    
    public NxRegLoadBuilder addAugmentation(Class<? extends Augmentation<NxRegLoad>> augmentationType, Augmentation<NxRegLoad> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxRegLoadBuilder removeAugmentation(Class<? extends Augmentation<NxRegLoad>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxRegLoad build() {
        return new NxRegLoadImpl(this);
    }

    private static final class NxRegLoadImpl implements NxRegLoad {
    
        private final Dst _dst;
        private final BigInteger _value;
    
        private Map<Class<? extends Augmentation<NxRegLoad>>, Augmentation<NxRegLoad>> augmentation = Collections.emptyMap();
    
        private NxRegLoadImpl(NxRegLoadBuilder base) {
            this._dst = base.getDst();
            this._value = base.getValue();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxRegLoad> getImplementedInterface() {
            return NxRegLoad.class;
        }
    
        @Override
        public Dst getDst() {
            return _dst;
        }
        
        @Override
        public BigInteger getValue() {
            return _value;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxRegLoad>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_dst);
            result = prime * result + Objects.hashCode(_value);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxRegLoad.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxRegLoad other = (NxRegLoad)obj;
            if (!Objects.equals(_dst, other.getDst())) {
                return false;
            }
            if (!Objects.equals(_value, other.getValue())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxRegLoadImpl otherImpl = (NxRegLoadImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxRegLoad>>, Augmentation<NxRegLoad>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxRegLoad");
            CodeHelpers.appendValue(helper, "_dst", _dst);
            CodeHelpers.appendValue(helper, "_value", _value);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
