package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nodes.node.table.flow.instructions.instruction.instruction.write.actions._case.write.actions.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.move.grouping.NxRegMove;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionRegMoveNodesNodeTableFlowWriteActionsCaseBuilder} instances.
 *
 * @see NxActionRegMoveNodesNodeTableFlowWriteActionsCaseBuilder
 *
 */
public class NxActionRegMoveNodesNodeTableFlowWriteActionsCaseBuilder implements Builder<NxActionRegMoveNodesNodeTableFlowWriteActionsCase> {

    private NxRegMove _nxRegMove;


    Map<Class<? extends Augmentation<NxActionRegMoveNodesNodeTableFlowWriteActionsCase>>, Augmentation<NxActionRegMoveNodesNodeTableFlowWriteActionsCase>> augmentation = Collections.emptyMap();

    public NxActionRegMoveNodesNodeTableFlowWriteActionsCaseBuilder() {
    }
    public NxActionRegMoveNodesNodeTableFlowWriteActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegMoveGrouping arg) {
        this._nxRegMove = arg.getNxRegMove();
    }

    public NxActionRegMoveNodesNodeTableFlowWriteActionsCaseBuilder(NxActionRegMoveNodesNodeTableFlowWriteActionsCase base) {
        this._nxRegMove = base.getNxRegMove();
        if (base instanceof NxActionRegMoveNodesNodeTableFlowWriteActionsCaseImpl) {
            NxActionRegMoveNodesNodeTableFlowWriteActionsCaseImpl impl = (NxActionRegMoveNodesNodeTableFlowWriteActionsCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<NxActionRegMoveNodesNodeTableFlowWriteActionsCase> casted =(AugmentationHolder<NxActionRegMoveNodesNodeTableFlowWriteActionsCase>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegMoveGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegMoveGrouping) {
            this._nxRegMove = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegMoveGrouping)arg).getNxRegMove();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegMoveGrouping]");
    }

    public NxRegMove getNxRegMove() {
        return _nxRegMove;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxActionRegMoveNodesNodeTableFlowWriteActionsCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionRegMoveNodesNodeTableFlowWriteActionsCaseBuilder setNxRegMove(final NxRegMove value) {
        this._nxRegMove = value;
        return this;
    }
    
    public NxActionRegMoveNodesNodeTableFlowWriteActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionRegMoveNodesNodeTableFlowWriteActionsCase>> augmentationType, Augmentation<NxActionRegMoveNodesNodeTableFlowWriteActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionRegMoveNodesNodeTableFlowWriteActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionRegMoveNodesNodeTableFlowWriteActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionRegMoveNodesNodeTableFlowWriteActionsCase build() {
        return new NxActionRegMoveNodesNodeTableFlowWriteActionsCaseImpl(this);
    }

    private static final class NxActionRegMoveNodesNodeTableFlowWriteActionsCaseImpl implements NxActionRegMoveNodesNodeTableFlowWriteActionsCase {
    
        private final NxRegMove _nxRegMove;
    
        private Map<Class<? extends Augmentation<NxActionRegMoveNodesNodeTableFlowWriteActionsCase>>, Augmentation<NxActionRegMoveNodesNodeTableFlowWriteActionsCase>> augmentation = Collections.emptyMap();
    
        private NxActionRegMoveNodesNodeTableFlowWriteActionsCaseImpl(NxActionRegMoveNodesNodeTableFlowWriteActionsCaseBuilder base) {
            this._nxRegMove = base.getNxRegMove();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionRegMoveNodesNodeTableFlowWriteActionsCase> getImplementedInterface() {
            return NxActionRegMoveNodesNodeTableFlowWriteActionsCase.class;
        }
    
        @Override
        public NxRegMove getNxRegMove() {
            return _nxRegMove;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxActionRegMoveNodesNodeTableFlowWriteActionsCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxRegMove);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionRegMoveNodesNodeTableFlowWriteActionsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionRegMoveNodesNodeTableFlowWriteActionsCase other = (NxActionRegMoveNodesNodeTableFlowWriteActionsCase)obj;
            if (!Objects.equals(_nxRegMove, other.getNxRegMove())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionRegMoveNodesNodeTableFlowWriteActionsCaseImpl otherImpl = (NxActionRegMoveNodesNodeTableFlowWriteActionsCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionRegMoveNodesNodeTableFlowWriteActionsCase>>, Augmentation<NxActionRegMoveNodesNodeTableFlowWriteActionsCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionRegMoveNodesNodeTableFlowWriteActionsCase");
            CodeHelpers.appendValue(helper, "_nxRegMove", _nxRegMove);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
