package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nodes.node.table.flow.instructions.instruction.instruction.write.actions._case.write.actions.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.NxOutputReg;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionOutputRegNodesNodeTableFlowWriteActionsCaseBuilder} instances.
 *
 * @see NxActionOutputRegNodesNodeTableFlowWriteActionsCaseBuilder
 *
 */
public class NxActionOutputRegNodesNodeTableFlowWriteActionsCaseBuilder implements Builder<NxActionOutputRegNodesNodeTableFlowWriteActionsCase> {

    private NxOutputReg _nxOutputReg;


    Map<Class<? extends Augmentation<NxActionOutputRegNodesNodeTableFlowWriteActionsCase>>, Augmentation<NxActionOutputRegNodesNodeTableFlowWriteActionsCase>> augmentation = Collections.emptyMap();

    public NxActionOutputRegNodesNodeTableFlowWriteActionsCaseBuilder() {
    }
    public NxActionOutputRegNodesNodeTableFlowWriteActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping arg) {
        this._nxOutputReg = arg.getNxOutputReg();
    }

    public NxActionOutputRegNodesNodeTableFlowWriteActionsCaseBuilder(NxActionOutputRegNodesNodeTableFlowWriteActionsCase base) {
        this._nxOutputReg = base.getNxOutputReg();
        if (base instanceof NxActionOutputRegNodesNodeTableFlowWriteActionsCaseImpl) {
            NxActionOutputRegNodesNodeTableFlowWriteActionsCaseImpl impl = (NxActionOutputRegNodesNodeTableFlowWriteActionsCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<NxActionOutputRegNodesNodeTableFlowWriteActionsCase> casted =(AugmentationHolder<NxActionOutputRegNodesNodeTableFlowWriteActionsCase>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping) {
            this._nxOutputReg = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping)arg).getNxOutputReg();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping]");
    }

    public NxOutputReg getNxOutputReg() {
        return _nxOutputReg;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxActionOutputRegNodesNodeTableFlowWriteActionsCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionOutputRegNodesNodeTableFlowWriteActionsCaseBuilder setNxOutputReg(final NxOutputReg value) {
        this._nxOutputReg = value;
        return this;
    }
    
    public NxActionOutputRegNodesNodeTableFlowWriteActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionOutputRegNodesNodeTableFlowWriteActionsCase>> augmentationType, Augmentation<NxActionOutputRegNodesNodeTableFlowWriteActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionOutputRegNodesNodeTableFlowWriteActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionOutputRegNodesNodeTableFlowWriteActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionOutputRegNodesNodeTableFlowWriteActionsCase build() {
        return new NxActionOutputRegNodesNodeTableFlowWriteActionsCaseImpl(this);
    }

    private static final class NxActionOutputRegNodesNodeTableFlowWriteActionsCaseImpl implements NxActionOutputRegNodesNodeTableFlowWriteActionsCase {
    
        private final NxOutputReg _nxOutputReg;
    
        private Map<Class<? extends Augmentation<NxActionOutputRegNodesNodeTableFlowWriteActionsCase>>, Augmentation<NxActionOutputRegNodesNodeTableFlowWriteActionsCase>> augmentation = Collections.emptyMap();
    
        private NxActionOutputRegNodesNodeTableFlowWriteActionsCaseImpl(NxActionOutputRegNodesNodeTableFlowWriteActionsCaseBuilder base) {
            this._nxOutputReg = base.getNxOutputReg();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionOutputRegNodesNodeTableFlowWriteActionsCase> getImplementedInterface() {
            return NxActionOutputRegNodesNodeTableFlowWriteActionsCase.class;
        }
    
        @Override
        public NxOutputReg getNxOutputReg() {
            return _nxOutputReg;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxActionOutputRegNodesNodeTableFlowWriteActionsCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxOutputReg);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionOutputRegNodesNodeTableFlowWriteActionsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionOutputRegNodesNodeTableFlowWriteActionsCase other = (NxActionOutputRegNodesNodeTableFlowWriteActionsCase)obj;
            if (!Objects.equals(_nxOutputReg, other.getNxOutputReg())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionOutputRegNodesNodeTableFlowWriteActionsCaseImpl otherImpl = (NxActionOutputRegNodesNodeTableFlowWriteActionsCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionOutputRegNodesNodeTableFlowWriteActionsCase>>, Augmentation<NxActionOutputRegNodesNodeTableFlowWriteActionsCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionOutputRegNodesNodeTableFlowWriteActionsCase");
            CodeHelpers.appendValue(helper, "_nxOutputReg", _nxOutputReg);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
