package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.get.flow.statistics.output.flow.and.statistics.map.list.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.move.grouping.NxRegMove;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCaseBuilder} instances.
 *
 * @see NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCaseBuilder
 *
 */
public class NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCaseBuilder implements Builder<NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCase> {

    private NxRegMove _nxRegMove;


    Map<Class<? extends Augmentation<NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCase>> augmentation = Collections.emptyMap();

    public NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCaseBuilder() {
    }
    public NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegMoveGrouping arg) {
        this._nxRegMove = arg.getNxRegMove();
    }

    public NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCaseBuilder(NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCase base) {
        this._nxRegMove = base.getNxRegMove();
        if (base instanceof NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCaseImpl) {
            NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCaseImpl impl = (NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCase> casted =(AugmentationHolder<NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCase>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegMoveGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegMoveGrouping) {
            this._nxRegMove = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegMoveGrouping)arg).getNxRegMove();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegMoveGrouping]");
    }

    public NxRegMove getNxRegMove() {
        return _nxRegMove;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCaseBuilder setNxRegMove(final NxRegMove value) {
        this._nxRegMove = value;
        return this;
    }
    
    public NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCase>> augmentationType, Augmentation<NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCase build() {
        return new NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCaseImpl(this);
    }

    private static final class NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCaseImpl implements NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCase {
    
        private final NxRegMove _nxRegMove;
    
        private Map<Class<? extends Augmentation<NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCase>> augmentation = Collections.emptyMap();
    
        private NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCaseImpl(NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCaseBuilder base) {
            this._nxRegMove = base.getNxRegMove();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCase> getImplementedInterface() {
            return NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCase.class;
        }
    
        @Override
        public NxRegMove getNxRegMove() {
            return _nxRegMove;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxRegMove);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCase other = (NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCase)obj;
            if (!Objects.equals(_nxRegMove, other.getNxRegMove())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCaseImpl otherImpl = (NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionRegMoveNotifDirectStatisticsUpdateApplyActionsCase");
            CodeHelpers.appendValue(helper, "_nxRegMove", _nxRegMove);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
