package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec.flow.mod.add.match.from.value._case;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link FlowModAddMatchFromValueBuilder} instances.
 *
 * @see FlowModAddMatchFromValueBuilder
 *
 */
public class FlowModAddMatchFromValueBuilder implements Builder<FlowModAddMatchFromValue> {

    private Integer _flowModNumBits;
    private Long _srcField;
    private Integer _srcOfs;
    private Integer _value;


    Map<Class<? extends Augmentation<FlowModAddMatchFromValue>>, Augmentation<FlowModAddMatchFromValue>> augmentation = Collections.emptyMap();

    public FlowModAddMatchFromValueBuilder() {
    }

    public FlowModAddMatchFromValueBuilder(FlowModAddMatchFromValue base) {
        this._flowModNumBits = base.getFlowModNumBits();
        this._srcField = base.getSrcField();
        this._srcOfs = base.getSrcOfs();
        this._value = base.getValue();
        if (base instanceof FlowModAddMatchFromValueImpl) {
            FlowModAddMatchFromValueImpl impl = (FlowModAddMatchFromValueImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<FlowModAddMatchFromValue> casted =(AugmentationHolder<FlowModAddMatchFromValue>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public Integer getFlowModNumBits() {
        return _flowModNumBits;
    }
    
    public Long getSrcField() {
        return _srcField;
    }
    
    public Integer getSrcOfs() {
        return _srcOfs;
    }
    
    public Integer getValue() {
        return _value;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<FlowModAddMatchFromValue>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkFlowModNumBitsRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public FlowModAddMatchFromValueBuilder setFlowModNumBits(final Integer value) {
    if (value != null) {
        checkFlowModNumBitsRange(value);
        
    }
        this._flowModNumBits = value;
        return this;
    }
    private static void checkSrcFieldRange(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }
    
    public FlowModAddMatchFromValueBuilder setSrcField(final Long value) {
    if (value != null) {
        checkSrcFieldRange(value);
        
    }
        this._srcField = value;
        return this;
    }
    private static void checkSrcOfsRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public FlowModAddMatchFromValueBuilder setSrcOfs(final Integer value) {
    if (value != null) {
        checkSrcOfsRange(value);
        
    }
        this._srcOfs = value;
        return this;
    }
    private static void checkValueRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public FlowModAddMatchFromValueBuilder setValue(final Integer value) {
    if (value != null) {
        checkValueRange(value);
        
    }
        this._value = value;
        return this;
    }
    
    public FlowModAddMatchFromValueBuilder addAugmentation(Class<? extends Augmentation<FlowModAddMatchFromValue>> augmentationType, Augmentation<FlowModAddMatchFromValue> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public FlowModAddMatchFromValueBuilder removeAugmentation(Class<? extends Augmentation<FlowModAddMatchFromValue>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public FlowModAddMatchFromValue build() {
        return new FlowModAddMatchFromValueImpl(this);
    }

    private static final class FlowModAddMatchFromValueImpl implements FlowModAddMatchFromValue {
    
        private final Integer _flowModNumBits;
        private final Long _srcField;
        private final Integer _srcOfs;
        private final Integer _value;
    
        private Map<Class<? extends Augmentation<FlowModAddMatchFromValue>>, Augmentation<FlowModAddMatchFromValue>> augmentation = Collections.emptyMap();
    
        private FlowModAddMatchFromValueImpl(FlowModAddMatchFromValueBuilder base) {
            this._flowModNumBits = base.getFlowModNumBits();
            this._srcField = base.getSrcField();
            this._srcOfs = base.getSrcOfs();
            this._value = base.getValue();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<FlowModAddMatchFromValue> getImplementedInterface() {
            return FlowModAddMatchFromValue.class;
        }
    
        @Override
        public Integer getFlowModNumBits() {
            return _flowModNumBits;
        }
        
        @Override
        public Long getSrcField() {
            return _srcField;
        }
        
        @Override
        public Integer getSrcOfs() {
            return _srcOfs;
        }
        
        @Override
        public Integer getValue() {
            return _value;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<FlowModAddMatchFromValue>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_flowModNumBits);
            result = prime * result + Objects.hashCode(_srcField);
            result = prime * result + Objects.hashCode(_srcOfs);
            result = prime * result + Objects.hashCode(_value);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowModAddMatchFromValue.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            FlowModAddMatchFromValue other = (FlowModAddMatchFromValue)obj;
            if (!Objects.equals(_flowModNumBits, other.getFlowModNumBits())) {
                return false;
            }
            if (!Objects.equals(_srcField, other.getSrcField())) {
                return false;
            }
            if (!Objects.equals(_srcOfs, other.getSrcOfs())) {
                return false;
            }
            if (!Objects.equals(_value, other.getValue())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                FlowModAddMatchFromValueImpl otherImpl = (FlowModAddMatchFromValueImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<FlowModAddMatchFromValue>>, Augmentation<FlowModAddMatchFromValue>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("FlowModAddMatchFromValue");
            CodeHelpers.appendValue(helper, "_flowModNumBits", _flowModNumBits);
            CodeHelpers.appendValue(helper, "_srcField", _srcField);
            CodeHelpers.appendValue(helper, "_srcOfs", _srcOfs);
            CodeHelpers.appendValue(helper, "_value", _value);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
