package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec.flow.mod.copy.value.into.field._case.FlowModCopyValueIntoField;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link FlowModCopyValueIntoFieldCaseBuilder} instances.
 *
 * @see FlowModCopyValueIntoFieldCaseBuilder
 *
 */
public class FlowModCopyValueIntoFieldCaseBuilder implements Builder<FlowModCopyValueIntoFieldCase> {

    private FlowModCopyValueIntoField _flowModCopyValueIntoField;


    Map<Class<? extends Augmentation<FlowModCopyValueIntoFieldCase>>, Augmentation<FlowModCopyValueIntoFieldCase>> augmentation = Collections.emptyMap();

    public FlowModCopyValueIntoFieldCaseBuilder() {
    }

    public FlowModCopyValueIntoFieldCaseBuilder(FlowModCopyValueIntoFieldCase base) {
        this._flowModCopyValueIntoField = base.getFlowModCopyValueIntoField();
        if (base instanceof FlowModCopyValueIntoFieldCaseImpl) {
            FlowModCopyValueIntoFieldCaseImpl impl = (FlowModCopyValueIntoFieldCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<FlowModCopyValueIntoFieldCase> casted =(AugmentationHolder<FlowModCopyValueIntoFieldCase>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public FlowModCopyValueIntoField getFlowModCopyValueIntoField() {
        return _flowModCopyValueIntoField;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<FlowModCopyValueIntoFieldCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public FlowModCopyValueIntoFieldCaseBuilder setFlowModCopyValueIntoField(final FlowModCopyValueIntoField value) {
        this._flowModCopyValueIntoField = value;
        return this;
    }
    
    public FlowModCopyValueIntoFieldCaseBuilder addAugmentation(Class<? extends Augmentation<FlowModCopyValueIntoFieldCase>> augmentationType, Augmentation<FlowModCopyValueIntoFieldCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public FlowModCopyValueIntoFieldCaseBuilder removeAugmentation(Class<? extends Augmentation<FlowModCopyValueIntoFieldCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public FlowModCopyValueIntoFieldCase build() {
        return new FlowModCopyValueIntoFieldCaseImpl(this);
    }

    private static final class FlowModCopyValueIntoFieldCaseImpl implements FlowModCopyValueIntoFieldCase {
    
        private final FlowModCopyValueIntoField _flowModCopyValueIntoField;
    
        private Map<Class<? extends Augmentation<FlowModCopyValueIntoFieldCase>>, Augmentation<FlowModCopyValueIntoFieldCase>> augmentation = Collections.emptyMap();
    
        private FlowModCopyValueIntoFieldCaseImpl(FlowModCopyValueIntoFieldCaseBuilder base) {
            this._flowModCopyValueIntoField = base.getFlowModCopyValueIntoField();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<FlowModCopyValueIntoFieldCase> getImplementedInterface() {
            return FlowModCopyValueIntoFieldCase.class;
        }
    
        @Override
        public FlowModCopyValueIntoField getFlowModCopyValueIntoField() {
            return _flowModCopyValueIntoField;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<FlowModCopyValueIntoFieldCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_flowModCopyValueIntoField);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowModCopyValueIntoFieldCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            FlowModCopyValueIntoFieldCase other = (FlowModCopyValueIntoFieldCase)obj;
            if (!Objects.equals(_flowModCopyValueIntoField, other.getFlowModCopyValueIntoField())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                FlowModCopyValueIntoFieldCaseImpl otherImpl = (FlowModCopyValueIntoFieldCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<FlowModCopyValueIntoFieldCase>>, Augmentation<FlowModCopyValueIntoFieldCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("FlowModCopyValueIntoFieldCase");
            CodeHelpers.appendValue(helper, "_flowModCopyValueIntoField", _flowModCopyValueIntoField);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
