package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec.flow.mod.copy.field.into.field._case.FlowModCopyFieldIntoField;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link FlowModCopyFieldIntoFieldCaseBuilder} instances.
 *
 * @see FlowModCopyFieldIntoFieldCaseBuilder
 *
 */
public class FlowModCopyFieldIntoFieldCaseBuilder implements Builder<FlowModCopyFieldIntoFieldCase> {

    private FlowModCopyFieldIntoField _flowModCopyFieldIntoField;


    Map<Class<? extends Augmentation<FlowModCopyFieldIntoFieldCase>>, Augmentation<FlowModCopyFieldIntoFieldCase>> augmentation = Collections.emptyMap();

    public FlowModCopyFieldIntoFieldCaseBuilder() {
    }

    public FlowModCopyFieldIntoFieldCaseBuilder(FlowModCopyFieldIntoFieldCase base) {
        this._flowModCopyFieldIntoField = base.getFlowModCopyFieldIntoField();
        if (base instanceof FlowModCopyFieldIntoFieldCaseImpl) {
            FlowModCopyFieldIntoFieldCaseImpl impl = (FlowModCopyFieldIntoFieldCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<FlowModCopyFieldIntoFieldCase> casted =(AugmentationHolder<FlowModCopyFieldIntoFieldCase>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public FlowModCopyFieldIntoField getFlowModCopyFieldIntoField() {
        return _flowModCopyFieldIntoField;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<FlowModCopyFieldIntoFieldCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public FlowModCopyFieldIntoFieldCaseBuilder setFlowModCopyFieldIntoField(final FlowModCopyFieldIntoField value) {
        this._flowModCopyFieldIntoField = value;
        return this;
    }
    
    public FlowModCopyFieldIntoFieldCaseBuilder addAugmentation(Class<? extends Augmentation<FlowModCopyFieldIntoFieldCase>> augmentationType, Augmentation<FlowModCopyFieldIntoFieldCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public FlowModCopyFieldIntoFieldCaseBuilder removeAugmentation(Class<? extends Augmentation<FlowModCopyFieldIntoFieldCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public FlowModCopyFieldIntoFieldCase build() {
        return new FlowModCopyFieldIntoFieldCaseImpl(this);
    }

    private static final class FlowModCopyFieldIntoFieldCaseImpl implements FlowModCopyFieldIntoFieldCase {
    
        private final FlowModCopyFieldIntoField _flowModCopyFieldIntoField;
    
        private Map<Class<? extends Augmentation<FlowModCopyFieldIntoFieldCase>>, Augmentation<FlowModCopyFieldIntoFieldCase>> augmentation = Collections.emptyMap();
    
        private FlowModCopyFieldIntoFieldCaseImpl(FlowModCopyFieldIntoFieldCaseBuilder base) {
            this._flowModCopyFieldIntoField = base.getFlowModCopyFieldIntoField();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<FlowModCopyFieldIntoFieldCase> getImplementedInterface() {
            return FlowModCopyFieldIntoFieldCase.class;
        }
    
        @Override
        public FlowModCopyFieldIntoField getFlowModCopyFieldIntoField() {
            return _flowModCopyFieldIntoField;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<FlowModCopyFieldIntoFieldCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_flowModCopyFieldIntoField);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowModCopyFieldIntoFieldCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            FlowModCopyFieldIntoFieldCase other = (FlowModCopyFieldIntoFieldCase)obj;
            if (!Objects.equals(_flowModCopyFieldIntoField, other.getFlowModCopyFieldIntoField())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                FlowModCopyFieldIntoFieldCaseImpl otherImpl = (FlowModCopyFieldIntoFieldCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<FlowModCopyFieldIntoFieldCase>>, Augmentation<FlowModCopyFieldIntoFieldCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("FlowModCopyFieldIntoFieldCase");
            CodeHelpers.appendValue(helper, "_flowModCopyFieldIntoField", _flowModCopyFieldIntoField);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
