package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.dst.choice;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link DstOfIpSrcCaseBuilder} instances.
 *
 * @see DstOfIpSrcCaseBuilder
 *
 */
public class DstOfIpSrcCaseBuilder implements Builder<DstOfIpSrcCase> {

    private Boolean _ofIpSrc;


    Map<Class<? extends Augmentation<DstOfIpSrcCase>>, Augmentation<DstOfIpSrcCase>> augmentation = Collections.emptyMap();

    public DstOfIpSrcCaseBuilder() {
    }
    public DstOfIpSrcCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfIpSrcGrouping arg) {
        this._ofIpSrc = arg.isOfIpSrc();
    }

    public DstOfIpSrcCaseBuilder(DstOfIpSrcCase base) {
        this._ofIpSrc = base.isOfIpSrc();
        if (base instanceof DstOfIpSrcCaseImpl) {
            DstOfIpSrcCaseImpl impl = (DstOfIpSrcCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<DstOfIpSrcCase> casted =(AugmentationHolder<DstOfIpSrcCase>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfIpSrcGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfIpSrcGrouping) {
            this._ofIpSrc = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfIpSrcGrouping)arg).isOfIpSrc();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfIpSrcGrouping]");
    }

    public Boolean isOfIpSrc() {
        return _ofIpSrc;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<DstOfIpSrcCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DstOfIpSrcCaseBuilder setOfIpSrc(final Boolean value) {
        this._ofIpSrc = value;
        return this;
    }
    
    public DstOfIpSrcCaseBuilder addAugmentation(Class<? extends Augmentation<DstOfIpSrcCase>> augmentationType, Augmentation<DstOfIpSrcCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DstOfIpSrcCaseBuilder removeAugmentation(Class<? extends Augmentation<DstOfIpSrcCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DstOfIpSrcCase build() {
        return new DstOfIpSrcCaseImpl(this);
    }

    private static final class DstOfIpSrcCaseImpl implements DstOfIpSrcCase {
    
        private final Boolean _ofIpSrc;
    
        private Map<Class<? extends Augmentation<DstOfIpSrcCase>>, Augmentation<DstOfIpSrcCase>> augmentation = Collections.emptyMap();
    
        private DstOfIpSrcCaseImpl(DstOfIpSrcCaseBuilder base) {
            this._ofIpSrc = base.isOfIpSrc();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<DstOfIpSrcCase> getImplementedInterface() {
            return DstOfIpSrcCase.class;
        }
    
        @Override
        public Boolean isOfIpSrc() {
            return _ofIpSrc;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<DstOfIpSrcCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ofIpSrc);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DstOfIpSrcCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DstOfIpSrcCase other = (DstOfIpSrcCase)obj;
            if (!Objects.equals(_ofIpSrc, other.isOfIpSrc())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DstOfIpSrcCaseImpl otherImpl = (DstOfIpSrcCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DstOfIpSrcCase>>, Augmentation<DstOfIpSrcCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DstOfIpSrcCase");
            CodeHelpers.appendValue(helper, "_ofIpSrc", _ofIpSrc);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
