package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.dst.choice;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link DstOfEthSrcCaseBuilder} instances.
 *
 * @see DstOfEthSrcCaseBuilder
 *
 */
public class DstOfEthSrcCaseBuilder implements Builder<DstOfEthSrcCase> {

    private Boolean _ofEthSrc;


    Map<Class<? extends Augmentation<DstOfEthSrcCase>>, Augmentation<DstOfEthSrcCase>> augmentation = Collections.emptyMap();

    public DstOfEthSrcCaseBuilder() {
    }
    public DstOfEthSrcCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfEthSrcGrouping arg) {
        this._ofEthSrc = arg.isOfEthSrc();
    }

    public DstOfEthSrcCaseBuilder(DstOfEthSrcCase base) {
        this._ofEthSrc = base.isOfEthSrc();
        if (base instanceof DstOfEthSrcCaseImpl) {
            DstOfEthSrcCaseImpl impl = (DstOfEthSrcCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<DstOfEthSrcCase> casted =(AugmentationHolder<DstOfEthSrcCase>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfEthSrcGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfEthSrcGrouping) {
            this._ofEthSrc = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfEthSrcGrouping)arg).isOfEthSrc();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfEthSrcGrouping]");
    }

    public Boolean isOfEthSrc() {
        return _ofEthSrc;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<DstOfEthSrcCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DstOfEthSrcCaseBuilder setOfEthSrc(final Boolean value) {
        this._ofEthSrc = value;
        return this;
    }
    
    public DstOfEthSrcCaseBuilder addAugmentation(Class<? extends Augmentation<DstOfEthSrcCase>> augmentationType, Augmentation<DstOfEthSrcCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DstOfEthSrcCaseBuilder removeAugmentation(Class<? extends Augmentation<DstOfEthSrcCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DstOfEthSrcCase build() {
        return new DstOfEthSrcCaseImpl(this);
    }

    private static final class DstOfEthSrcCaseImpl implements DstOfEthSrcCase {
    
        private final Boolean _ofEthSrc;
    
        private Map<Class<? extends Augmentation<DstOfEthSrcCase>>, Augmentation<DstOfEthSrcCase>> augmentation = Collections.emptyMap();
    
        private DstOfEthSrcCaseImpl(DstOfEthSrcCaseBuilder base) {
            this._ofEthSrc = base.isOfEthSrc();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<DstOfEthSrcCase> getImplementedInterface() {
            return DstOfEthSrcCase.class;
        }
    
        @Override
        public Boolean isOfEthSrc() {
            return _ofEthSrc;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<DstOfEthSrcCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ofEthSrc);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DstOfEthSrcCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DstOfEthSrcCase other = (DstOfEthSrcCase)obj;
            if (!Objects.equals(_ofEthSrc, other.isOfEthSrc())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DstOfEthSrcCaseImpl otherImpl = (DstOfEthSrcCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DstOfEthSrcCase>>, Augmentation<DstOfEthSrcCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DstOfEthSrcCase");
            CodeHelpers.appendValue(helper, "_ofEthSrc", _ofEthSrc);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
