package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.nx.conntrack.CtActions;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-action</b>
 * <pre>
 * container nx-conntrack {
 *     leaf flags {
 *         type uint16;
 *     }
 *     leaf zone-src {
 *         type uint32;
 *     }
 *     leaf conntrack-zone {
 *         type uint16;
 *     }
 *     leaf recirc-table {
 *         type uint8;
 *     }
 *     list ct-actions {
 *         key     choice ofpact-actions {
 *             case nx-action-ct-mark-case {
 *                 container nx-action-ct-mark {
 *                     leaf ct-mark {
 *                         type uint32;
 *                     }
 *                 }
 *             }
 *             case nx-action-nat-case {
 *                 container nx-action-nat {
 *                     leaf flags {
 *                         type uint16;
 *                     }
 *                     leaf range_present {
 *                         type uint16;
 *                     }
 *                     leaf ip-address-min {
 *                         type ip-address;
 *                     }
 *                     leaf ip-address-max {
 *                         type ip-address;
 *                     }
 *                     leaf port-min {
 *                         type uint16;
 *                     }
 *                     leaf port-max {
 *                         type uint16;
 *                     }
 *                 }
 *             }
 *         }
 *         uses ofpact-actions;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-action/nx-action-conntrack-grouping/nx-conntrack</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrackBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrackBuilder
 *
 */
public interface NxConntrack
    extends
    ChildOf<NxActionConntrackGrouping>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:openflowplugin:extension:nicira:action",
        "2014-07-14", "nx-conntrack").intern();

    /**
     * @return <code>java.lang.Integer</code> <code>flags</code>, or <code>null</code> if not present
     */
    java.lang.Integer getFlags();
    
    /**
     * @return <code>java.lang.Long</code> <code>zoneSrc</code>, or <code>null</code> if not present
     */
    java.lang.Long getZoneSrc();
    
    /**
     * @return <code>java.lang.Integer</code> <code>conntrackZone</code>, or <code>null</code> if not present
     */
    java.lang.Integer getConntrackZone();
    
    /**
     * @return <code>java.lang.Short</code> <code>recircTable</code>, or <code>null</code> if not present
     */
    java.lang.Short getRecircTable();
    
    /**
     * @return <code>java.util.List</code> <code>ctActions</code>, or <code>null</code> if not present
     */
    List<CtActions> getCtActions();

}

