/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.match;

import com.google.common.base.Optional;
import org.opendaylight.openflowplugin.extension.api.ConvertorFromOFJava;
import org.opendaylight.openflowplugin.extension.api.ConvertorToOFJava;
import org.opendaylight.openflowplugin.extension.api.ExtensionAugment;
import org.opendaylight.openflowplugin.extension.api.path.AugmentationPath;
import org.opendaylight.openflowplugin.extension.api.path.MatchPath;
import org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.CodecPreconditionException;
import org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.match.MatchUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Nxm1Class;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.nx.match.encap.eth.src.grouping.EncapEthSrcValuesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.EncapEthSrcCaseValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.EncapEthSrcCaseValueBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.general.rev140714.ExtensionKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.general.rev140714.general.extension.grouping.Extension;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNotifPacketIn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNotifPacketInBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNotifSwitchFlowRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNotifSwitchFlowRemovedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNotifUpdateFlowStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNotifUpdateFlowStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchPacketInMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchPacketInMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchRpcGetFlowStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchRpcGetFlowStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxEncapEthSrcGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxEncapEthSrcKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.encap.eth.src.grouping.NxmNxEncapEthSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.encap.eth.src.grouping.NxmNxEncapEthSrcBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class EncapEthSrcConvertor
implements ConvertorToOFJava<MatchEntry>,
ConvertorFromOFJava<MatchEntry, MatchPath> {
    public ExtensionAugment<? extends Augmentation<Extension>> convert(MatchEntry input, MatchPath path) {
        EncapEthSrcCaseValue encapEthSrcCaseValue = (EncapEthSrcCaseValue)input.getMatchEntryValue();
        return EncapEthSrcConvertor.resolveAugmentation(new NxmNxEncapEthSrcBuilder().setMacAddress(encapEthSrcCaseValue.getEncapEthSrcValues().getMacAddress()).build(), path, NxmNxEncapEthSrcKey.class);
    }

    private static ExtensionAugment<? extends Augmentation<Extension>> resolveAugmentation(NxmNxEncapEthSrc value, MatchPath path, Class<? extends ExtensionKey> key) {
        switch (path) {
            case FLOWSSTATISTICSUPDATE_FLOWANDSTATISTICSMAPLIST_MATCH: {
                return new ExtensionAugment(NxAugMatchNotifUpdateFlowStats.class, (Augmentation)new NxAugMatchNotifUpdateFlowStatsBuilder().setNxmNxEncapEthSrc(value).build(), key);
            }
            case RPCFLOWSSTATISTICS_FLOWANDSTATISTICSMAPLIST_MATCH: {
                return new ExtensionAugment(NxAugMatchRpcGetFlowStats.class, (Augmentation)new NxAugMatchRpcGetFlowStatsBuilder().setNxmNxEncapEthSrc(value).build(), key);
            }
            case PACKETRECEIVED_MATCH: {
                return new ExtensionAugment(NxAugMatchNotifPacketIn.class, (Augmentation)new NxAugMatchNotifPacketInBuilder().setNxmNxEncapEthSrc(value).build(), key);
            }
            case SWITCHFLOWREMOVED_MATCH: {
                return new ExtensionAugment(NxAugMatchNotifSwitchFlowRemoved.class, (Augmentation)new NxAugMatchNotifSwitchFlowRemovedBuilder().setNxmNxEncapEthSrc(value).build(), key);
            }
            case PACKETINMESSAGE_MATCH: {
                return new ExtensionAugment(NxAugMatchPacketInMessage.class, (Augmentation)new NxAugMatchPacketInMessageBuilder().setNxmNxEncapEthSrc(value).build(), key);
            }
        }
        throw new CodecPreconditionException((AugmentationPath)path);
    }

    public MatchEntry convert(Extension extension) {
        Optional matchGrouping = MatchUtil.encapEthSrcResolver.getExtension((Augmentable)extension);
        if (!matchGrouping.isPresent()) {
            throw new CodecPreconditionException(extension);
        }
        MacAddress macAddress = ((NxmNxEncapEthSrcGrouping)matchGrouping.get()).getNxmNxEncapEthSrc().getMacAddress();
        EncapEthSrcCaseValueBuilder encapEthSrcCaseValueBuilder = new EncapEthSrcCaseValueBuilder();
        encapEthSrcCaseValueBuilder.setEncapEthSrcValues(new EncapEthSrcValuesBuilder().setMacAddress(macAddress).build());
        return MatchUtil.createDefaultMatchEntryBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmNxEncapEthSrc.class, Nxm1Class.class, (MatchEntryValue)encapEthSrcCaseValueBuilder.build()).build();
    }
}

