package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OfpactActions;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-action</b>
 * <pre>
 * container nx-action-nat {
 *     leaf flags {
 *         type uint16;
 *     }
 *     leaf range_present {
 *         type uint16;
 *     }
 *     leaf ip-address-min {
 *         type ip-address;
 *     }
 *     leaf ip-address-max {
 *         type ip-address;
 *     }
 *     leaf port-min {
 *         type uint16;
 *     }
 *     leaf port-max {
 *         type uint16;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-action/ofpact-actions/ofpact-actions/nx-action-nat-case/nx-action-nat</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNatBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNatBuilder
 *
 */
public interface NxActionNat
    extends
    ChildOf<OfpactActions>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:openflowplugin:extension:nicira:action",
        "2014-07-14", "nx-action-nat").intern();

    /**
     * @return <code>java.lang.Integer</code> <code>flags</code>, or <code>null</code> if not present
     */
    java.lang.Integer getFlags();
    
    /**
     * @return <code>java.lang.Integer</code> <code>rangePresent</code>, or <code>null</code> if not present
     */
    java.lang.Integer getRangePresent();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress</code> <code>ipAddressMin</code>, or <code>null</code> if not present
     */
    IpAddress getIpAddressMin();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress</code> <code>ipAddressMax</code>, or <code>null</code> if not present
     */
    IpAddress getIpAddressMax();
    
    /**
     * @return <code>java.lang.Integer</code> <code>portMin</code>, or <code>null</code> if not present
     */
    java.lang.Integer getPortMin();
    
    /**
     * @return <code>java.lang.Integer</code> <code>portMax</code>, or <code>null</code> if not present
     */
    java.lang.Integer getPortMax();

}

