/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.extension.vendor.nicira.convertor;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.ListIterator;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yangtools.yang.common.Uint32;

public final class IpConverter {
    private static final Splitter SPLITTER = Splitter.on((char)'.').trimResults().omitEmptyStrings();

    private IpConverter() {
    }

    public static long ipv4AddressToLong(Ipv4Address ipv4Address) {
        long result = 0L;
        List splittedAddress = SPLITTER.splitToList((CharSequence)ipv4Address.getValue());
        int maxIndex = splittedAddress.size() - 1;
        ListIterator listIter = splittedAddress.listIterator();
        while (listIter.hasNext()) {
            String current = (String)listIter.next();
            int index = splittedAddress.indexOf(current);
            result |= Long.parseLong(current) << (maxIndex - index) * 8;
        }
        return result & 0xFFFFFFFFFFFFFFFFL;
    }

    public static Ipv4Address longToIpv4Address(Uint32 ip) {
        return IpConverter.longToIpv4Address(ip.toJava());
    }

    public static Ipv4Address longToIpv4Address(long ip) {
        long tmpIp = ip;
        StringBuilder sb = new StringBuilder(15);
        for (int i = 0; i < 4; ++i) {
            sb.insert(0, Long.toString(tmpIp & 0xFFL));
            if (i < 3) {
                sb.insert(0, '.');
            }
            tmpIp >>= 8;
        }
        return new Ipv4Address(sb.toString());
    }
}

