package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.reg.grouping;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link NxmNxRegBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxmNxRegBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxmNxRegBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxmNxRegBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxmNxRegBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class NxmNxRegBuilder implements Builder<NxmNxReg> {

    private Uint32 _mask;
    private Class<? extends org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmNxReg> _reg;
    private Uint32 _value;


    Map<Class<? extends Augmentation<NxmNxReg>>, Augmentation<NxmNxReg>> augmentation = Collections.emptyMap();

    public NxmNxRegBuilder() {
    }
    
    

    public NxmNxRegBuilder(NxmNxReg base) {
        Map<Class<? extends Augmentation<NxmNxReg>>, Augmentation<NxmNxReg>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._mask = base.getMask();
        this._reg = base.getReg();
        this._value = base.getValue();
    }


    public Uint32 getMask() {
        return _mask;
    }
    
    public Class<? extends org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmNxReg> getReg() {
        return _reg;
    }
    
    public Uint32 getValue() {
        return _value;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxmNxReg>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public NxmNxRegBuilder setMask(final Uint32 value) {
        this._mask = value;
        return this;
    }
    
    public NxmNxRegBuilder setReg(final Class<? extends org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmNxReg> value) {
        this._reg = value;
        return this;
    }
    
    public NxmNxRegBuilder setValue(final Uint32 value) {
        this._value = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NxmNxRegBuilder addAugmentation(Augmentation<NxmNxReg> augmentation) {
        Class<? extends Augmentation<NxmNxReg>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NxmNxRegBuilder removeAugmentation(Class<? extends Augmentation<NxmNxReg>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxmNxReg build() {
        return new NxmNxRegImpl(this);
    }

    private static final class NxmNxRegImpl
        extends AbstractAugmentable<NxmNxReg>
        implements NxmNxReg {
    
        private final Uint32 _mask;
        private final Class<? extends org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmNxReg> _reg;
        private final Uint32 _value;
    
        NxmNxRegImpl(NxmNxRegBuilder base) {
            super(base.augmentation);
            this._mask = base.getMask();
            this._reg = base.getReg();
            this._value = base.getValue();
        }
    
        @Override
        public Uint32 getMask() {
            return _mask;
        }
        
        @Override
        public Class<? extends org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmNxReg> getReg() {
            return _reg;
        }
        
        @Override
        public Uint32 getValue() {
            return _value;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NxmNxReg.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return NxmNxReg.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NxmNxReg.bindingToString(this);
        }
    }
}
