package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * Class that builds {@link NxActionNatBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxActionNatBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxActionNatBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxActionNatBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxActionNatBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class NxActionNatBuilder implements Builder<NxActionNat> {

    private Uint16 _flags;
    private IpAddress _ipAddressMax;
    private IpAddress _ipAddressMin;
    private Uint16 _portMax;
    private Uint16 _portMin;
    private Uint16 _rangePresent;


    Map<Class<? extends Augmentation<NxActionNat>>, Augmentation<NxActionNat>> augmentation = Collections.emptyMap();

    public NxActionNatBuilder() {
    }
    
    

    public NxActionNatBuilder(NxActionNat base) {
        Map<Class<? extends Augmentation<NxActionNat>>, Augmentation<NxActionNat>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._flags = base.getFlags();
        this._ipAddressMax = base.getIpAddressMax();
        this._ipAddressMin = base.getIpAddressMin();
        this._portMax = base.getPortMax();
        this._portMin = base.getPortMin();
        this._rangePresent = base.getRangePresent();
    }


    public Uint16 getFlags() {
        return _flags;
    }
    
    public IpAddress getIpAddressMax() {
        return _ipAddressMax;
    }
    
    public IpAddress getIpAddressMin() {
        return _ipAddressMin;
    }
    
    public Uint16 getPortMax() {
        return _portMax;
    }
    
    public Uint16 getPortMin() {
        return _portMin;
    }
    
    public Uint16 getRangePresent() {
        return _rangePresent;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionNat>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public NxActionNatBuilder setFlags(final Uint16 value) {
        this._flags = value;
        return this;
    }
    
    public NxActionNatBuilder setIpAddressMax(final IpAddress value) {
        this._ipAddressMax = value;
        return this;
    }
    
    public NxActionNatBuilder setIpAddressMin(final IpAddress value) {
        this._ipAddressMin = value;
        return this;
    }
    
    public NxActionNatBuilder setPortMax(final Uint16 value) {
        this._portMax = value;
        return this;
    }
    
    public NxActionNatBuilder setPortMin(final Uint16 value) {
        this._portMin = value;
        return this;
    }
    
    public NxActionNatBuilder setRangePresent(final Uint16 value) {
        this._rangePresent = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NxActionNatBuilder addAugmentation(Augmentation<NxActionNat> augmentation) {
        Class<? extends Augmentation<NxActionNat>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NxActionNatBuilder removeAugmentation(Class<? extends Augmentation<NxActionNat>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionNat build() {
        return new NxActionNatImpl(this);
    }

    private static final class NxActionNatImpl
        extends AbstractAugmentable<NxActionNat>
        implements NxActionNat {
    
        private final Uint16 _flags;
        private final IpAddress _ipAddressMax;
        private final IpAddress _ipAddressMin;
        private final Uint16 _portMax;
        private final Uint16 _portMin;
        private final Uint16 _rangePresent;
    
        NxActionNatImpl(NxActionNatBuilder base) {
            super(base.augmentation);
            this._flags = base.getFlags();
            this._ipAddressMax = base.getIpAddressMax();
            this._ipAddressMin = base.getIpAddressMin();
            this._portMax = base.getPortMax();
            this._portMin = base.getPortMin();
            this._rangePresent = base.getRangePresent();
        }
    
        @Override
        public Uint16 getFlags() {
            return _flags;
        }
        
        @Override
        public IpAddress getIpAddressMax() {
            return _ipAddressMax;
        }
        
        @Override
        public IpAddress getIpAddressMin() {
            return _ipAddressMin;
        }
        
        @Override
        public Uint16 getPortMax() {
            return _portMax;
        }
        
        @Override
        public Uint16 getPortMin() {
            return _portMin;
        }
        
        @Override
        public Uint16 getRangePresent() {
            return _rangePresent;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NxActionNat.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return NxActionNat.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NxActionNat.bindingToString(this);
        }
    }
}
