package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionResubmitGrouping;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Re-searches OpenFlow flow table (or the table whose number is specified by 
 * table) with the in-port field replaced by port (if port is specified) and 
 * executes the actions found
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-action</b>
 * <pre>
 * container nx-resubmit {
 *   leaf in-port {
 *     type uint16;
 *     default 0xfff8;
 *   }
 *   leaf table {
 *     type uint8 {
 *       range "0 .. 255";
 *     }
 *     default 255;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-actionnx-action-resubmit-groupingnx-resubmit</i>
 *
 * <p>To create instances of this class use {@link NxResubmitBuilder}.
 * @see NxResubmitBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface NxResubmit
    extends
    ChildOf<NxActionResubmitGrouping>,
    Augmentable<NxResubmit>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("nx-resubmit");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping.NxResubmit> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping.NxResubmit.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping.@NonNull NxResubmit obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getInPort());
        result = prime * result + Objects.hashCode(obj.getTable());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping.@NonNull NxResubmit thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping.NxResubmit other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping.NxResubmit.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getInPort(), other.getInPort())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTable(), other.getTable())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping.@NonNull NxResubmit obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxResubmit");
        CodeHelpers.appendValue(helper, "inPort", obj.getInPort());
        CodeHelpers.appendValue(helper, "table", obj.getTable());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return inPort, or {@code null} if it is not present.
     *
     * @return {@code Uint16} inPort, or {@code null} if it is not present.
     *
     */
    Uint16 getInPort();
    
    /**
     * Return inPort, guaranteed to be non-null.
     *
     * @return {@code Uint16} inPort, guaranteed to be non-null.
     * @throws NoSuchElementException if inPort is not present
     *
     */
    default @NonNull Uint16 requireInPort() {
        return CodeHelpers.require(getInPort(), "inport");
    }
    
    /**
     * Return table, or {@code null} if it is not present.
     *
     * @return {@code Uint8} table, or {@code null} if it is not present.
     *
     */
    Uint8 getTable();
    
    /**
     * Return table, guaranteed to be non-null.
     *
     * @return {@code Uint8} table, guaranteed to be non-null.
     * @throws NoSuchElementException if table is not present
     *
     */
    default @NonNull Uint8 requireTable() {
        return CodeHelpers.require(getTable(), "table");
    }

}

