package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.move.grouping.nx.reg.move;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.RangeGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.SrcChoiceGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.SrcChoice;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * Class that builds {@link SrcBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     SrcBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new SrcBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of SrcBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see SrcBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class SrcBuilder implements Builder<Src> {

    private Uint16 _end;
    private SrcChoice _srcChoice;
    private Uint16 _start;


    Map<Class<? extends Augmentation<Src>>, Augmentation<Src>> augmentation = Collections.emptyMap();

    public SrcBuilder() {
    }
    
    
    
    public SrcBuilder(SrcChoiceGrouping arg) {
        this._srcChoice = arg.getSrcChoice();
    }
    
    public SrcBuilder(RangeGrouping arg) {
        this._start = arg.getStart();
        this._end = arg.getEnd();
    }

    public SrcBuilder(Src base) {
        Map<Class<? extends Augmentation<Src>>, Augmentation<Src>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._end = base.getEnd();
        this._srcChoice = base.getSrcChoice();
        this._start = base.getStart();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>SrcChoiceGrouping</li>
     * <li>RangeGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SrcChoiceGrouping) {
            this._srcChoice = ((SrcChoiceGrouping)arg).getSrcChoice();
            isValidArg = true;
        }
        if (arg instanceof RangeGrouping) {
            this._start = ((RangeGrouping)arg).getStart();
            this._end = ((RangeGrouping)arg).getEnd();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[SrcChoiceGrouping, RangeGrouping]");
    }

    public Uint16 getEnd() {
        return _end;
    }
    
    public SrcChoice getSrcChoice() {
        return _srcChoice;
    }
    
    public Uint16 getStart() {
        return _start;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Src>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public SrcBuilder setEnd(final Uint16 value) {
        this._end = value;
        return this;
    }
    
    public SrcBuilder setSrcChoice(final SrcChoice value) {
        this._srcChoice = value;
        return this;
    }
    
    public SrcBuilder setStart(final Uint16 value) {
        this._start = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SrcBuilder addAugmentation(Augmentation<Src> augmentation) {
        Class<? extends Augmentation<Src>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SrcBuilder removeAugmentation(Class<? extends Augmentation<Src>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Src build() {
        return new SrcImpl(this);
    }

    private static final class SrcImpl
        extends AbstractAugmentable<Src>
        implements Src {
    
        private final Uint16 _end;
        private final SrcChoice _srcChoice;
        private final Uint16 _start;
    
        SrcImpl(SrcBuilder base) {
            super(base.augmentation);
            this._end = base.getEnd();
            this._srcChoice = base.getSrcChoice();
            this._start = base.getStart();
        }
    
        @Override
        public Uint16 getEnd() {
            return _end;
        }
        
        @Override
        public SrcChoice getSrcChoice() {
            return _srcChoice;
        }
        
        @Override
        public Uint16 getStart() {
            return _start;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Src.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Src.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Src.bindingToString(this);
        }
    }
}
