package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.nx.output.reg;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.SrcChoiceGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.NxOutputReg;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * Choose the register with the OpenFlow output port, using the number of bits 
 * specified from the register.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-action</b>
 * <pre>
 * container src {
 *   uses src-choice-grouping;
 *   leaf ofs_nbits {
 *     type uint16;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-actionnx-action-output-reg-groupingnx-output-regsrc</i>
 *
 * <p>To create instances of this class use {@link SrcBuilder}.
 * @see SrcBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Src
    extends
    ChildOf<NxOutputReg>,
    Augmentable<Src>,
    SrcChoiceGrouping
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("src");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.nx.output.reg.Src> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.nx.output.reg.Src.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.nx.output.reg.@NonNull Src obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getOfsNbits());
        result = prime * result + Objects.hashCode(obj.getSrcChoice());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.nx.output.reg.@NonNull Src thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.nx.output.reg.Src other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.nx.output.reg.Src.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getOfsNbits(), other.getOfsNbits())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSrcChoice(), other.getSrcChoice())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.nx.output.reg.@NonNull Src obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Src");
        CodeHelpers.appendValue(helper, "ofsNbits", obj.getOfsNbits());
        CodeHelpers.appendValue(helper, "srcChoice", obj.getSrcChoice());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return ofsNbits, or {@code null} if it is not present.
     *
     * @return {@code Uint16} ofsNbits, or {@code null} if it is not present.
     *
     */
    Uint16 getOfsNbits();
    
    /**
     * Return ofsNbits, guaranteed to be non-null.
     *
     * @return {@code Uint16} ofsNbits, guaranteed to be non-null.
     * @throws NoSuchElementException if ofsNbits is not present
     *
     */
    default @NonNull Uint16 requireOfsNbits() {
        return CodeHelpers.require(getOfsNbits(), "ofsnbits");
    }

}

