package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.nx.multipath;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.DstChoiceGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.RangeGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.DstChoice;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * Class that builds {@link DstBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     DstBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new DstBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of DstBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see DstBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class DstBuilder implements Builder<Dst> {

    private DstChoice _dstChoice;
    private Uint16 _end;
    private Uint16 _start;


    Map<Class<? extends Augmentation<Dst>>, Augmentation<Dst>> augmentation = Collections.emptyMap();

    public DstBuilder() {
    }
    
    
    
    public DstBuilder(DstChoiceGrouping arg) {
        this._dstChoice = arg.getDstChoice();
    }
    
    public DstBuilder(RangeGrouping arg) {
        this._start = arg.getStart();
        this._end = arg.getEnd();
    }

    public DstBuilder(Dst base) {
        Map<Class<? extends Augmentation<Dst>>, Augmentation<Dst>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._dstChoice = base.getDstChoice();
        this._end = base.getEnd();
        this._start = base.getStart();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>RangeGrouping</li>
     * <li>DstChoiceGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof RangeGrouping) {
            this._start = ((RangeGrouping)arg).getStart();
            this._end = ((RangeGrouping)arg).getEnd();
            isValidArg = true;
        }
        if (arg instanceof DstChoiceGrouping) {
            this._dstChoice = ((DstChoiceGrouping)arg).getDstChoice();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[RangeGrouping, DstChoiceGrouping]");
    }

    public DstChoice getDstChoice() {
        return _dstChoice;
    }
    
    public Uint16 getEnd() {
        return _end;
    }
    
    public Uint16 getStart() {
        return _start;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Dst>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public DstBuilder setDstChoice(final DstChoice value) {
        this._dstChoice = value;
        return this;
    }
    
    public DstBuilder setEnd(final Uint16 value) {
        this._end = value;
        return this;
    }
    
    public DstBuilder setStart(final Uint16 value) {
        this._start = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public DstBuilder addAugmentation(Augmentation<Dst> augmentation) {
        Class<? extends Augmentation<Dst>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public DstBuilder removeAugmentation(Class<? extends Augmentation<Dst>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Dst build() {
        return new DstImpl(this);
    }

    private static final class DstImpl
        extends AbstractAugmentable<Dst>
        implements Dst {
    
        private final DstChoice _dstChoice;
        private final Uint16 _end;
        private final Uint16 _start;
    
        DstImpl(DstBuilder base) {
            super(base.augmentation);
            this._dstChoice = base.getDstChoice();
            this._end = base.getEnd();
            this._start = base.getStart();
        }
    
        @Override
        public DstChoice getDstChoice() {
            return _dstChoice;
        }
        
        @Override
        public Uint16 getEnd() {
            return _end;
        }
        
        @Override
        public Uint16 getStart() {
            return _start;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Dst.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Dst.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Dst.bindingToString(this);
        }
    }
}
