package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.nx.conntrack.CtActions;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link NxConntrackBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxConntrackBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxConntrackBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxConntrackBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxConntrackBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class NxConntrackBuilder implements Builder<NxConntrack> {

    private Uint16 _conntrackZone;
    private List<CtActions> _ctActions;
    private Uint16 _flags;
    private Uint8 _recircTable;
    private Uint32 _zoneSrc;


    Map<Class<? extends Augmentation<NxConntrack>>, Augmentation<NxConntrack>> augmentation = Collections.emptyMap();

    public NxConntrackBuilder() {
    }
    
    

    public NxConntrackBuilder(NxConntrack base) {
        Map<Class<? extends Augmentation<NxConntrack>>, Augmentation<NxConntrack>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._conntrackZone = base.getConntrackZone();
        this._ctActions = base.getCtActions();
        this._flags = base.getFlags();
        this._recircTable = base.getRecircTable();
        this._zoneSrc = base.getZoneSrc();
    }


    public Uint16 getConntrackZone() {
        return _conntrackZone;
    }
    
    public List<CtActions> getCtActions() {
        return _ctActions;
    }
    
    public Uint16 getFlags() {
        return _flags;
    }
    
    public Uint8 getRecircTable() {
        return _recircTable;
    }
    
    public Uint32 getZoneSrc() {
        return _zoneSrc;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxConntrack>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public NxConntrackBuilder setConntrackZone(final Uint16 value) {
        this._conntrackZone = value;
        return this;
    }
    public NxConntrackBuilder setCtActions(final List<CtActions> values) {
        this._ctActions = values;
        return this;
    }
    
    
    public NxConntrackBuilder setFlags(final Uint16 value) {
        this._flags = value;
        return this;
    }
    
    public NxConntrackBuilder setRecircTable(final Uint8 value) {
        this._recircTable = value;
        return this;
    }
    
    public NxConntrackBuilder setZoneSrc(final Uint32 value) {
        this._zoneSrc = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NxConntrackBuilder addAugmentation(Augmentation<NxConntrack> augmentation) {
        Class<? extends Augmentation<NxConntrack>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NxConntrackBuilder removeAugmentation(Class<? extends Augmentation<NxConntrack>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxConntrack build() {
        return new NxConntrackImpl(this);
    }

    private static final class NxConntrackImpl
        extends AbstractAugmentable<NxConntrack>
        implements NxConntrack {
    
        private final Uint16 _conntrackZone;
        private final List<CtActions> _ctActions;
        private final Uint16 _flags;
        private final Uint8 _recircTable;
        private final Uint32 _zoneSrc;
    
        NxConntrackImpl(NxConntrackBuilder base) {
            super(base.augmentation);
            this._conntrackZone = base.getConntrackZone();
            this._ctActions = CodeHelpers.emptyToNull(base.getCtActions());
            this._flags = base.getFlags();
            this._recircTable = base.getRecircTable();
            this._zoneSrc = base.getZoneSrc();
        }
    
        @Override
        public Uint16 getConntrackZone() {
            return _conntrackZone;
        }
        
        @Override
        public List<CtActions> getCtActions() {
            return _ctActions;
        }
        
        @Override
        public Uint16 getFlags() {
            return _flags;
        }
        
        @Override
        public Uint8 getRecircTable() {
            return _recircTable;
        }
        
        @Override
        public Uint32 getZoneSrc() {
            return _zoneSrc;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NxConntrack.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return NxConntrack.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NxConntrack.bindingToString(this);
        }
    }
}
