package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.dst.choice;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIpv4SrcGrouping;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Empty;

/**
 * Class that builds {@link DstNxTunIpv4SrcCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     DstNxTunIpv4SrcCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new DstNxTunIpv4SrcCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of DstNxTunIpv4SrcCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see DstNxTunIpv4SrcCaseBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class DstNxTunIpv4SrcCaseBuilder implements Builder<DstNxTunIpv4SrcCase> {

    private Empty _nxTunIpv4Src;


    Map<Class<? extends Augmentation<DstNxTunIpv4SrcCase>>, Augmentation<DstNxTunIpv4SrcCase>> augmentation = Collections.emptyMap();

    public DstNxTunIpv4SrcCaseBuilder() {
    }
    
    
    
    
    public DstNxTunIpv4SrcCaseBuilder(NxmNxTunIpv4SrcGrouping arg) {
        this._nxTunIpv4Src = arg.getNxTunIpv4Src();
    }

    public DstNxTunIpv4SrcCaseBuilder(DstNxTunIpv4SrcCase base) {
        Map<Class<? extends Augmentation<DstNxTunIpv4SrcCase>>, Augmentation<DstNxTunIpv4SrcCase>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._nxTunIpv4Src = base.getNxTunIpv4Src();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>NxmNxTunIpv4SrcGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NxmNxTunIpv4SrcGrouping) {
            this._nxTunIpv4Src = ((NxmNxTunIpv4SrcGrouping)arg).getNxTunIpv4Src();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[NxmNxTunIpv4SrcGrouping]");
    }

    public Empty getNxTunIpv4Src() {
        return _nxTunIpv4Src;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<DstNxTunIpv4SrcCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public DstNxTunIpv4SrcCaseBuilder setNxTunIpv4Src(final Empty value) {
        this._nxTunIpv4Src = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public DstNxTunIpv4SrcCaseBuilder addAugmentation(Augmentation<DstNxTunIpv4SrcCase> augmentation) {
        Class<? extends Augmentation<DstNxTunIpv4SrcCase>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public DstNxTunIpv4SrcCaseBuilder removeAugmentation(Class<? extends Augmentation<DstNxTunIpv4SrcCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DstNxTunIpv4SrcCase build() {
        return new DstNxTunIpv4SrcCaseImpl(this);
    }

    private static final class DstNxTunIpv4SrcCaseImpl
        extends AbstractAugmentable<DstNxTunIpv4SrcCase>
        implements DstNxTunIpv4SrcCase {
    
        private final Empty _nxTunIpv4Src;
    
        DstNxTunIpv4SrcCaseImpl(DstNxTunIpv4SrcCaseBuilder base) {
            super(base.augmentation);
            this._nxTunIpv4Src = base.getNxTunIpv4Src();
        }
    
        @Override
        public Empty getNxTunIpv4Src() {
            return _nxTunIpv4Src;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = DstNxTunIpv4SrcCase.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return DstNxTunIpv4SrcCase.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return DstNxTunIpv4SrcCase.bindingToString(this);
        }
    }
}
