package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nsh.flags.grouping;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.Short;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link NxmNxNshFlagsBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxmNxNshFlagsBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxmNxNshFlagsBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxmNxNshFlagsBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxmNxNshFlagsBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class NxmNxNshFlagsBuilder implements Builder<NxmNxNshFlags> {

    private Uint8 _mask;
    private Uint8 _nshFlags;


    Map<Class<? extends Augmentation<NxmNxNshFlags>>, Augmentation<NxmNxNshFlags>> augmentation = Collections.emptyMap();

    public NxmNxNshFlagsBuilder() {
    }
    
    

    public NxmNxNshFlagsBuilder(NxmNxNshFlags base) {
        Map<Class<? extends Augmentation<NxmNxNshFlags>>, Augmentation<NxmNxNshFlags>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._mask = base.getMask();
        this._nshFlags = base.getNshFlags();
    }


    public Uint8 getMask() {
        return _mask;
    }
    
    public Uint8 getNshFlags() {
        return _nshFlags;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxmNxNshFlags>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public NxmNxNshFlagsBuilder setMask(final Uint8 value) {
        this._mask = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {@link #setMask(Uint8)} instead.
     */
    @Deprecated(forRemoval = true)
    public NxmNxNshFlagsBuilder setMask(final Short value) {
        return setMask(CodeHelpers.compatUint(value));
    }
    
    public NxmNxNshFlagsBuilder setNshFlags(final Uint8 value) {
        this._nshFlags = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {@link #setNshFlags(Uint8)} instead.
     */
    @Deprecated(forRemoval = true)
    public NxmNxNshFlagsBuilder setNshFlags(final Short value) {
        return setNshFlags(CodeHelpers.compatUint(value));
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NxmNxNshFlagsBuilder addAugmentation(Augmentation<NxmNxNshFlags> augmentation) {
        Class<? extends Augmentation<NxmNxNshFlags>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NxmNxNshFlagsBuilder removeAugmentation(Class<? extends Augmentation<NxmNxNshFlags>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxmNxNshFlags build() {
        return new NxmNxNshFlagsImpl(this);
    }

    private static final class NxmNxNshFlagsImpl
        extends AbstractAugmentable<NxmNxNshFlags>
        implements NxmNxNshFlags {
    
        private final Uint8 _mask;
        private final Uint8 _nshFlags;
    
        NxmNxNshFlagsImpl(NxmNxNshFlagsBuilder base) {
            super(base.augmentation);
            this._mask = base.getMask();
            this._nshFlags = base.getNshFlags();
        }
    
        @Override
        public Uint8 getMask() {
            return _mask;
        }
        
        @Override
        public Uint8 getNshFlags() {
            return _nshFlags;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NxmNxNshFlags.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return NxmNxNshFlags.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NxmNxNshFlags.bindingToString(this);
        }
    }
}
