package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nsh.ttl.grouping;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.Short;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link NxmNxNshTtlBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxmNxNshTtlBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxmNxNshTtlBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxmNxNshTtlBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxmNxNshTtlBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class NxmNxNshTtlBuilder implements Builder<NxmNxNshTtl> {

    private Uint8 _nshTtl;


    Map<Class<? extends Augmentation<NxmNxNshTtl>>, Augmentation<NxmNxNshTtl>> augmentation = Collections.emptyMap();

    public NxmNxNshTtlBuilder() {
    }
    
    

    public NxmNxNshTtlBuilder(NxmNxNshTtl base) {
        Map<Class<? extends Augmentation<NxmNxNshTtl>>, Augmentation<NxmNxNshTtl>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._nshTtl = base.getNshTtl();
    }


    public Uint8 getNshTtl() {
        return _nshTtl;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxmNxNshTtl>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public NxmNxNshTtlBuilder setNshTtl(final Uint8 value) {
        this._nshTtl = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {@link #setNshTtl(Uint8)} instead.
     */
    @Deprecated(forRemoval = true)
    public NxmNxNshTtlBuilder setNshTtl(final Short value) {
        return setNshTtl(CodeHelpers.compatUint(value));
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NxmNxNshTtlBuilder addAugmentation(Augmentation<NxmNxNshTtl> augmentation) {
        Class<? extends Augmentation<NxmNxNshTtl>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NxmNxNshTtlBuilder removeAugmentation(Class<? extends Augmentation<NxmNxNshTtl>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxmNxNshTtl build() {
        return new NxmNxNshTtlImpl(this);
    }

    private static final class NxmNxNshTtlImpl
        extends AbstractAugmentable<NxmNxNshTtl>
        implements NxmNxNshTtl {
    
        private final Uint8 _nshTtl;
    
        NxmNxNshTtlImpl(NxmNxNshTtlBuilder base) {
            super(base.augmentation);
            this._nshTtl = base.getNshTtl();
        }
    
        @Override
        public Uint8 getNshTtl() {
            return _nshTtl;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NxmNxNshTtl.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return NxmNxNshTtl.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NxmNxNshTtl.bindingToString(this);
        }
    }
}
