package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.dst.choice;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Empty;

/**
 * Class that builds {@link DstOfIcmpTypeCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     DstOfIcmpTypeCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new DstOfIcmpTypeCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of DstOfIcmpTypeCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see DstOfIcmpTypeCaseBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class DstOfIcmpTypeCaseBuilder implements Builder<DstOfIcmpTypeCase> {

    private Empty _ofIcmpType;


    Map<Class<? extends Augmentation<DstOfIcmpTypeCase>>, Augmentation<DstOfIcmpTypeCase>> augmentation = Collections.emptyMap();

    public DstOfIcmpTypeCaseBuilder() {
    }
    
    
    
    public DstOfIcmpTypeCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfIcmpTypeGrouping arg) {
        this._ofIcmpType = arg.getOfIcmpType();
    }
    

    public DstOfIcmpTypeCaseBuilder(DstOfIcmpTypeCase base) {
        Map<Class<? extends Augmentation<DstOfIcmpTypeCase>>, Augmentation<DstOfIcmpTypeCase>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._ofIcmpType = base.getOfIcmpType();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfIcmpTypeGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfIcmpTypeGrouping) {
            this._ofIcmpType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfIcmpTypeGrouping)arg).getOfIcmpType();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfIcmpTypeGrouping]");
    }

    public Empty getOfIcmpType() {
        return _ofIcmpType;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<DstOfIcmpTypeCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public DstOfIcmpTypeCaseBuilder setOfIcmpType(final Empty value) {
        this._ofIcmpType = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public DstOfIcmpTypeCaseBuilder addAugmentation(Augmentation<DstOfIcmpTypeCase> augmentation) {
        Class<? extends Augmentation<DstOfIcmpTypeCase>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public DstOfIcmpTypeCaseBuilder removeAugmentation(Class<? extends Augmentation<DstOfIcmpTypeCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DstOfIcmpTypeCase build() {
        return new DstOfIcmpTypeCaseImpl(this);
    }

    private static final class DstOfIcmpTypeCaseImpl
        extends AbstractAugmentable<DstOfIcmpTypeCase>
        implements DstOfIcmpTypeCase {
    
        private final Empty _ofIcmpType;
    
        DstOfIcmpTypeCaseImpl(DstOfIcmpTypeCaseBuilder base) {
            super(base.augmentation);
            this._ofIcmpType = base.getOfIcmpType();
        }
    
        @Override
        public Empty getOfIcmpType() {
            return _ofIcmpType;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = DstOfIcmpTypeCase.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return DstOfIcmpTypeCase.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return DstOfIcmpTypeCase.bindingToString(this);
        }
    }
}
