package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.udp.dst.grouping;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * Class that builds {@link NxmOfUdpDstBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxmOfUdpDstBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxmOfUdpDstBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxmOfUdpDstBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxmOfUdpDstBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class NxmOfUdpDstBuilder implements Builder<NxmOfUdpDst> {

    private Uint16 _mask;
    private PortNumber _port;


    Map<Class<? extends Augmentation<NxmOfUdpDst>>, Augmentation<NxmOfUdpDst>> augmentation = Collections.emptyMap();

    public NxmOfUdpDstBuilder() {
    }
    
    

    public NxmOfUdpDstBuilder(NxmOfUdpDst base) {
        Map<Class<? extends Augmentation<NxmOfUdpDst>>, Augmentation<NxmOfUdpDst>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._mask = base.getMask();
        this._port = base.getPort();
    }


    public Uint16 getMask() {
        return _mask;
    }
    
    public PortNumber getPort() {
        return _port;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxmOfUdpDst>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public NxmOfUdpDstBuilder setMask(final Uint16 value) {
        this._mask = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {@link #setMask(Uint16)} instead.
     */
    @Deprecated(forRemoval = true)
    public NxmOfUdpDstBuilder setMask(final Integer value) {
        return setMask(CodeHelpers.compatUint(value));
    }
    
    public NxmOfUdpDstBuilder setPort(final PortNumber value) {
        this._port = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NxmOfUdpDstBuilder addAugmentation(Augmentation<NxmOfUdpDst> augmentation) {
        Class<? extends Augmentation<NxmOfUdpDst>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NxmOfUdpDstBuilder removeAugmentation(Class<? extends Augmentation<NxmOfUdpDst>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxmOfUdpDst build() {
        return new NxmOfUdpDstImpl(this);
    }

    private static final class NxmOfUdpDstImpl
        extends AbstractAugmentable<NxmOfUdpDst>
        implements NxmOfUdpDst {
    
        private final Uint16 _mask;
        private final PortNumber _port;
    
        NxmOfUdpDstImpl(NxmOfUdpDstBuilder base) {
            super(base.augmentation);
            this._mask = base.getMask();
            this._port = base.getPort();
        }
    
        @Override
        public Uint16 getMask() {
            return _mask;
        }
        
        @Override
        public PortNumber getPort() {
            return _port;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NxmOfUdpDst.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return NxmOfUdpDst.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NxmOfUdpDst.bindingToString(this);
        }
    }
}
