package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Empty;

/**
 * Class that builds {@link SrcNxIpv6DstCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     SrcNxIpv6DstCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new SrcNxIpv6DstCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of SrcNxIpv6DstCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see SrcNxIpv6DstCaseBuilder
 * @see Builder
 *
 */
public class SrcNxIpv6DstCaseBuilder implements Builder<SrcNxIpv6DstCase> {

    private Empty _nxIpv6Dst;


    Map<Class<? extends Augmentation<SrcNxIpv6DstCase>>, Augmentation<SrcNxIpv6DstCase>> augmentation = Collections.emptyMap();

    public SrcNxIpv6DstCaseBuilder() {
    }
    public SrcNxIpv6DstCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxIpv6DstGrouping arg) {
        this._nxIpv6Dst = arg.getNxIpv6Dst();
    }

    public SrcNxIpv6DstCaseBuilder(SrcNxIpv6DstCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SrcNxIpv6DstCase>>, Augmentation<SrcNxIpv6DstCase>> aug =((AugmentationHolder<SrcNxIpv6DstCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxIpv6Dst = base.getNxIpv6Dst();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxIpv6DstGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxIpv6DstGrouping) {
            this._nxIpv6Dst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxIpv6DstGrouping)arg).getNxIpv6Dst();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxIpv6DstGrouping]");
    }

    public Empty getNxIpv6Dst() {
        return _nxIpv6Dst;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SrcNxIpv6DstCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public SrcNxIpv6DstCaseBuilder setNxIpv6Dst(final Empty value) {
        this._nxIpv6Dst = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SrcNxIpv6DstCaseBuilder addAugmentation(Augmentation<SrcNxIpv6DstCase> augmentation) {
        return doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }
    
    /**
      * Add or remove an augmentation to this builder's product.
      *
      * @param augmentationType augmentation type to be added or removed
      * @param augmentationValue augmentation value, null if the augmentation type should be removed
      * @return this builder
      * @deprecated Use either {@link #addAugmentation(Augmentation)} or {@link #removeAugmentation(Class)} instead.
      */
    @Deprecated(forRemoval = true)
    public SrcNxIpv6DstCaseBuilder addAugmentation(Class<? extends Augmentation<SrcNxIpv6DstCase>> augmentationType, Augmentation<SrcNxIpv6DstCase> augmentationValue) {
        return augmentationValue == null ? removeAugmentation(augmentationType) : doAddAugmentation(augmentationType, augmentationValue);
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SrcNxIpv6DstCaseBuilder removeAugmentation(Class<? extends Augmentation<SrcNxIpv6DstCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }
    
    private SrcNxIpv6DstCaseBuilder doAddAugmentation(Class<? extends Augmentation<SrcNxIpv6DstCase>> augmentationType, Augmentation<SrcNxIpv6DstCase> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    @Override
    public SrcNxIpv6DstCase build() {
        return new SrcNxIpv6DstCaseImpl(this);
    }

    private static final class SrcNxIpv6DstCaseImpl
        extends AbstractAugmentable<SrcNxIpv6DstCase>
        implements SrcNxIpv6DstCase {
    
        private final Empty _nxIpv6Dst;
    
        SrcNxIpv6DstCaseImpl(SrcNxIpv6DstCaseBuilder base) {
            super(base.augmentation);
            this._nxIpv6Dst = base.getNxIpv6Dst();
        }
    
        @Override
        public Empty getNxIpv6Dst() {
            return _nxIpv6Dst;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxIpv6Dst);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcNxIpv6DstCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            SrcNxIpv6DstCase other = (SrcNxIpv6DstCase)obj;
            if (!Objects.equals(_nxIpv6Dst, other.getNxIpv6Dst())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcNxIpv6DstCaseImpl otherImpl = (SrcNxIpv6DstCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcNxIpv6DstCase>>, Augmentation<SrcNxIpv6DstCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcNxIpv6DstCase");
            CodeHelpers.appendValue(helper, "_nxIpv6Dst", _nxIpv6Dst);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
