package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionResubmitGrouping;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Re-searches OpenFlow flow table (or the table whose number is specified by 
 * table) with the in-port field replaced by port (if port is specified) and 
 * executes the actions found
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-action</b>
 * <pre>
 * container nx-resubmit {
 *   leaf in-port {
 *     type uint16;
 *     default 0xfff8;
 *   }
 *   leaf table {
 *     type uint8 {
 *       range "0 .. 255";
 *     }
 *     default 255;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-action/nx-action-resubmit-grouping/nx-resubmit</i>
 *
 * <p>To create instances of this class use {@link NxResubmitBuilder}.
 * @see NxResubmitBuilder
 *
 */
public interface NxResubmit
    extends
    ChildOf<NxActionResubmitGrouping>,
    Augmentable<NxResubmit>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("nx-resubmit");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping.NxResubmit> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping.NxResubmit.class;
    }
    
    /**
     * @return <code>org.opendaylight.yangtools.yang.common.Uint16</code> <code>inPort</code>, or <code>null</code> if not present
     */
    Uint16 getInPort();
    
    /**
     * @return <code>org.opendaylight.yangtools.yang.common.Uint8</code> <code>table</code>, or <code>null</code> if not present
     */
    Uint8 getTable();

}

