package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.nx.conntrack.CtActions;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-action</b>
 * <pre>
 * container nx-conntrack {
 *   leaf flags {
 *     type uint16;
 *   }
 *   leaf zone-src {
 *     type uint32;
 *   }
 *   leaf conntrack-zone {
 *     type uint16;
 *   }
 *   leaf recirc-table {
 *     type uint8;
 *   }
 *   list ct-actions {
 *     uses ofpact-actions;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-action/nx-action-conntrack-grouping/nx-conntrack</i>
 *
 * <p>To create instances of this class use {@link NxConntrackBuilder}.
 * @see NxConntrackBuilder
 *
 */
public interface NxConntrack
    extends
    ChildOf<NxActionConntrackGrouping>,
    Augmentable<NxConntrack>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("nx-conntrack");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack.class;
    }
    
    /**
     * @return <code>org.opendaylight.yangtools.yang.common.Uint16</code> <code>flags</code>, or <code>null</code> if not present
     */
    Uint16 getFlags();
    
    /**
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>zoneSrc</code>, or <code>null</code> if not present
     */
    Uint32 getZoneSrc();
    
    /**
     * @return <code>org.opendaylight.yangtools.yang.common.Uint16</code> <code>conntrackZone</code>, or <code>null</code> if not present
     */
    Uint16 getConntrackZone();
    
    /**
     * @return <code>org.opendaylight.yangtools.yang.common.Uint8</code> <code>recircTable</code>, or <code>null</code> if not present
     */
    Uint8 getRecircTable();
    
    /**
     * @return <code>java.util.List</code> <code>ctActions</code>, or <code>null</code> if not present
     */
    @Nullable List<CtActions> getCtActions();
    
    /**
     * @return <code>java.util.List</code> <code>ctActions</code>, or an empty list if it is not present
     */
    default @NonNull List<CtActions> nonnullCtActions() {
        return CodeHelpers.nonnull(getCtActions());
    }

}

