package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.nx.output.reg;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.SrcChoiceGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.NxOutputReg;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * Choose the register with the OpenFlow output port, using the number of bits 
 * specified from the register.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-action</b>
 * <pre>
 * container src {
 *   uses src-choice-grouping;
 *   leaf ofs_nbits {
 *     type uint16;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-action/nx-action-output-reg-grouping/nx-output-reg/src</i>
 *
 * <p>To create instances of this class use {@link SrcBuilder}.
 * @see SrcBuilder
 *
 */
public interface Src
    extends
    ChildOf<NxOutputReg>,
    Augmentable<Src>,
    SrcChoiceGrouping
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("src");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.nx.output.reg.Src> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.nx.output.reg.Src.class;
    }
    
    /**
     * @return <code>org.opendaylight.yangtools.yang.common.Uint16</code> <code>ofsNbits</code>, or <code>null</code> if not present
     */
    @Nullable Uint16 getOfsNbits();

}

