/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.action;

import com.google.common.base.Preconditions;
import org.opendaylight.openflowplugin.extension.api.ConvertorActionFromOFJava;
import org.opendaylight.openflowplugin.extension.api.ConvertorActionToOFJava;
import org.opendaylight.openflowplugin.extension.api.path.ActionPath;
import org.opendaylight.openflowplugin.extension.api.path.AugmentationPath;
import org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.CodecPreconditionException;
import org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.action.ActionUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionDecap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionDecapBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.decap.grouping.NxActionDecap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.decap.grouping.NxActionDecapBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecapGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flows.statistics.update.flow.and.statistics.map.list.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action.NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flows.statistics.update.flow.and.statistics.map.list.instructions.instruction.instruction.write.actions._case.write.actions.action.action.NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.get.flow.statistics.output.flow.and.statistics.map.list.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action.NxActionDecapNotifDirectStatisticsUpdateApplyActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.get.flow.statistics.output.flow.and.statistics.map.list.instructions.instruction.instruction.write.actions._case.write.actions.action.action.NxActionDecapNotifDirectStatisticsUpdateWriteActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.group.desc.stats.updated.group.desc.stats.buckets.bucket.action.action.NxActionDecapNotifGroupDescStatsUpdatedCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nodes.node.table.flow.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action.NxActionDecapNodesNodeTableFlowApplyActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nodes.node.table.flow.instructions.instruction.instruction.write.actions._case.write.actions.action.action.NxActionDecapNodesNodeTableFlowWriteActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.decap.grouping.NxDecap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.decap.grouping.NxDecapBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;

public class DecapConvertor
implements ConvertorActionToOFJava<Action, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action>,
ConvertorActionFromOFJava<org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action, ActionPath> {
    public Action convert(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action input, ActionPath path) {
        ActionDecap actionDecap = (ActionDecap)input.getActionChoice();
        Uint32 packetType = actionDecap.getNxActionDecap().getPacketType();
        NxDecap nxDecap = new NxDecapBuilder().setPacketType(packetType).build();
        return DecapConvertor.resolveAction(nxDecap, path);
    }

    public org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action convert(Action actionCase) {
        Preconditions.checkArgument((boolean)(actionCase instanceof NxActionDecapGrouping));
        NxActionDecapGrouping nxActionDecapGrouping = (NxActionDecapGrouping)actionCase;
        Uint32 packetType = nxActionDecapGrouping.getNxDecap().getPacketType();
        NxActionDecap nxActionDecap = new NxActionDecapBuilder().setPacketType(packetType).build();
        ActionDecap actionDecap = new ActionDecapBuilder().setNxActionDecap(nxActionDecap).build();
        return ActionUtil.createAction((ActionChoice)actionDecap);
    }

    private static Action resolveAction(NxDecap value, ActionPath path) {
        switch (path) {
            case INVENTORY_FLOWNODE_TABLE_WRITE_ACTIONS: {
                return new NxActionDecapNodesNodeTableFlowWriteActionsCaseBuilder().setNxDecap(value).build();
            }
            case FLOWS_STATISTICS_UPDATE_WRITE_ACTIONS: {
                return new NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCaseBuilder().setNxDecap(value).build();
            }
            case FLOWS_STATISTICS_UPDATE_APPLY_ACTIONS: {
                return new NxActionDecapNotifFlowsStatisticsUpdateApplyActionsCaseBuilder().setNxDecap(value).build();
            }
            case GROUP_DESC_STATS_UPDATED_BUCKET_ACTION: {
                return new NxActionDecapNotifGroupDescStatsUpdatedCaseBuilder().setNxDecap(value).build();
            }
            case FLOWS_STATISTICS_RPC_WRITE_ACTIONS: {
                return new NxActionDecapNotifDirectStatisticsUpdateWriteActionsCaseBuilder().setNxDecap(value).build();
            }
            case FLOWS_STATISTICS_RPC_APPLY_ACTIONS: {
                return new NxActionDecapNotifDirectStatisticsUpdateApplyActionsCaseBuilder().setNxDecap(value).build();
            }
            case INVENTORY_FLOWNODE_TABLE_APPLY_ACTIONS: {
                return new NxActionDecapNodesNodeTableFlowApplyActionsCaseBuilder().setNxDecap(value).build();
            }
        }
        throw new CodecPreconditionException((AugmentationPath)path);
    }
}

