package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.arp.sha.grouping.NxmNxArpSha;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.arp.tha.grouping.NxmNxArpTha;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.mark.grouping.NxmNxCtMark;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.state.grouping.NxmNxCtState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.tp.dst.grouping.NxmNxCtTpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.tp.src.grouping.NxmNxCtTpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.zone.grouping.NxmNxCtZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nsh.flags.grouping.NxmNxNshFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nsh.mdtype.grouping.NxmNxNshMdtype;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nsh.np.grouping.NxmNxNshNp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nsh.ttl.grouping.NxmNxNshTtl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nshc._1.grouping.NxmNxNshc1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nshc._2.grouping.NxmNxNshc2;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nshc._3.grouping.NxmNxNshc3;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nshc._4.grouping.NxmNxNshc4;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nsi.grouping.NxmNxNsi;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nsp.grouping.NxmNxNsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.pkt.mark.grouping.NxmNxPktMark;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.reg.grouping.NxmNxReg;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.tun.id.grouping.NxmNxTunId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.tun.ipv4.dst.grouping.NxmNxTunIpv4Dst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.tun.ipv4.src.grouping.NxmNxTunIpv4Src;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.arp.op.grouping.NxmOfArpOp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.arp.spa.grouping.NxmOfArpSpa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.arp.tpa.grouping.NxmOfArpTpa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.eth.dst.grouping.NxmOfEthDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.eth.src.grouping.NxmOfEthSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.eth.type.grouping.NxmOfEthType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.icmp.type.grouping.NxmOfIcmpType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.in.port.grouping.OfInPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.ip.dst.grouping.NxmOfIpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.ip.src.grouping.NxmOfIpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.tcp.dst.grouping.NxmOfTcpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.tcp.src.grouping.NxmOfTcpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.udp.dst.grouping.NxmOfUdpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.udp.src.grouping.NxmOfUdpSrc;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxAugMatchPacketInMessageBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxAugMatchPacketInMessageBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxAugMatchPacketInMessageBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxAugMatchPacketInMessageBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxAugMatchPacketInMessageBuilder
 * @see Builder
 *
 */
public class NxAugMatchPacketInMessageBuilder implements Builder<NxAugMatchPacketInMessage> {

    private NxmNxArpSha _nxmNxArpSha;
    private NxmNxArpTha _nxmNxArpTha;
    private NxmNxCtMark _nxmNxCtMark;
    private NxmNxCtState _nxmNxCtState;
    private NxmNxCtTpDst _nxmNxCtTpDst;
    private NxmNxCtTpSrc _nxmNxCtTpSrc;
    private NxmNxCtZone _nxmNxCtZone;
    private NxmNxNshFlags _nxmNxNshFlags;
    private NxmNxNshMdtype _nxmNxNshMdtype;
    private NxmNxNshNp _nxmNxNshNp;
    private NxmNxNshTtl _nxmNxNshTtl;
    private NxmNxNshc1 _nxmNxNshc1;
    private NxmNxNshc2 _nxmNxNshc2;
    private NxmNxNshc3 _nxmNxNshc3;
    private NxmNxNshc4 _nxmNxNshc4;
    private NxmNxNsi _nxmNxNsi;
    private NxmNxNsp _nxmNxNsp;
    private NxmNxPktMark _nxmNxPktMark;
    private NxmNxReg _nxmNxReg;
    private NxmNxTunId _nxmNxTunId;
    private NxmNxTunIpv4Dst _nxmNxTunIpv4Dst;
    private NxmNxTunIpv4Src _nxmNxTunIpv4Src;
    private NxmOfArpOp _nxmOfArpOp;
    private NxmOfArpSpa _nxmOfArpSpa;
    private NxmOfArpTpa _nxmOfArpTpa;
    private NxmOfEthDst _nxmOfEthDst;
    private NxmOfEthSrc _nxmOfEthSrc;
    private NxmOfEthType _nxmOfEthType;
    private NxmOfIcmpType _nxmOfIcmpType;
    private NxmOfIpDst _nxmOfIpDst;
    private NxmOfIpSrc _nxmOfIpSrc;
    private NxmOfTcpDst _nxmOfTcpDst;
    private NxmOfTcpSrc _nxmOfTcpSrc;
    private NxmOfUdpDst _nxmOfUdpDst;
    private NxmOfUdpSrc _nxmOfUdpSrc;
    private OfInPort _ofInPort;



    public NxAugMatchPacketInMessageBuilder() {
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.AllMatchesGrouping arg) {
        this._nxmNxCtZone = arg.getNxmNxCtZone();
        this._nxmOfTcpSrc = arg.getNxmOfTcpSrc();
        this._nxmNxNshNp = arg.getNxmNxNshNp();
        this._nxmOfEthDst = arg.getNxmOfEthDst();
        this._nxmNxCtTpSrc = arg.getNxmNxCtTpSrc();
        this._nxmNxNshc4 = arg.getNxmNxNshc4();
        this._nxmNxTunId = arg.getNxmNxTunId();
        this._nxmNxCtTpDst = arg.getNxmNxCtTpDst();
        this._nxmOfUdpDst = arg.getNxmOfUdpDst();
        this._nxmNxReg = arg.getNxmNxReg();
        this._ofInPort = arg.getOfInPort();
        this._nxmNxCtMark = arg.getNxmNxCtMark();
        this._nxmOfEthType = arg.getNxmOfEthType();
        this._nxmNxNsp = arg.getNxmNxNsp();
        this._nxmNxNshTtl = arg.getNxmNxNshTtl();
        this._nxmNxNshc2 = arg.getNxmNxNshc2();
        this._nxmOfIpDst = arg.getNxmOfIpDst();
        this._nxmNxCtState = arg.getNxmNxCtState();
        this._nxmNxTunIpv4Src = arg.getNxmNxTunIpv4Src();
        this._nxmOfUdpSrc = arg.getNxmOfUdpSrc();
        this._nxmNxArpTha = arg.getNxmNxArpTha();
        this._nxmNxTunIpv4Dst = arg.getNxmNxTunIpv4Dst();
        this._nxmNxNsi = arg.getNxmNxNsi();
        this._nxmOfEthSrc = arg.getNxmOfEthSrc();
        this._nxmOfTcpDst = arg.getNxmOfTcpDst();
        this._nxmNxNshc3 = arg.getNxmNxNshc3();
        this._nxmOfIpSrc = arg.getNxmOfIpSrc();
        this._nxmOfArpSpa = arg.getNxmOfArpSpa();
        this._nxmNxPktMark = arg.getNxmNxPktMark();
        this._nxmNxArpSha = arg.getNxmNxArpSha();
        this._nxmNxNshc1 = arg.getNxmNxNshc1();
        this._nxmNxNshFlags = arg.getNxmNxNshFlags();
        this._nxmOfIcmpType = arg.getNxmOfIcmpType();
        this._nxmOfArpOp = arg.getNxmOfArpOp();
        this._nxmOfArpTpa = arg.getNxmOfArpTpa();
        this._nxmNxNshMdtype = arg.getNxmNxNshMdtype();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtZoneGrouping arg) {
        this._nxmNxCtZone = arg.getNxmNxCtZone();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfTcpSrcGrouping arg) {
        this._nxmOfTcpSrc = arg.getNxmOfTcpSrc();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshNpGrouping arg) {
        this._nxmNxNshNp = arg.getNxmNxNshNp();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthDstGrouping arg) {
        this._nxmOfEthDst = arg.getNxmOfEthDst();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtTpSrcGrouping arg) {
        this._nxmNxCtTpSrc = arg.getNxmNxCtTpSrc();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc4Grouping arg) {
        this._nxmNxNshc4 = arg.getNxmNxNshc4();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIdGrouping arg) {
        this._nxmNxTunId = arg.getNxmNxTunId();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtTpDstGrouping arg) {
        this._nxmNxCtTpDst = arg.getNxmNxCtTpDst();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfUdpDstGrouping arg) {
        this._nxmOfUdpDst = arg.getNxmOfUdpDst();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxRegGrouping arg) {
        this._nxmNxReg = arg.getNxmNxReg();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfInPortGrouping arg) {
        this._ofInPort = arg.getOfInPort();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtMarkGrouping arg) {
        this._nxmNxCtMark = arg.getNxmNxCtMark();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthTypeGrouping arg) {
        this._nxmOfEthType = arg.getNxmOfEthType();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNspGrouping arg) {
        this._nxmNxNsp = arg.getNxmNxNsp();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshTtlGrouping arg) {
        this._nxmNxNshTtl = arg.getNxmNxNshTtl();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc2Grouping arg) {
        this._nxmNxNshc2 = arg.getNxmNxNshc2();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIpDstGrouping arg) {
        this._nxmOfIpDst = arg.getNxmOfIpDst();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtStateGrouping arg) {
        this._nxmNxCtState = arg.getNxmNxCtState();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIpv4SrcGrouping arg) {
        this._nxmNxTunIpv4Src = arg.getNxmNxTunIpv4Src();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfUdpSrcGrouping arg) {
        this._nxmOfUdpSrc = arg.getNxmOfUdpSrc();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxArpThaGrouping arg) {
        this._nxmNxArpTha = arg.getNxmNxArpTha();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIpv4DstGrouping arg) {
        this._nxmNxTunIpv4Dst = arg.getNxmNxTunIpv4Dst();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNsiGrouping arg) {
        this._nxmNxNsi = arg.getNxmNxNsi();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthSrcGrouping arg) {
        this._nxmOfEthSrc = arg.getNxmOfEthSrc();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfTcpDstGrouping arg) {
        this._nxmOfTcpDst = arg.getNxmOfTcpDst();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc3Grouping arg) {
        this._nxmNxNshc3 = arg.getNxmNxNshc3();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIpSrcGrouping arg) {
        this._nxmOfIpSrc = arg.getNxmOfIpSrc();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpSpaGrouping arg) {
        this._nxmOfArpSpa = arg.getNxmOfArpSpa();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxPktMarkGrouping arg) {
        this._nxmNxPktMark = arg.getNxmNxPktMark();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxArpShaGrouping arg) {
        this._nxmNxArpSha = arg.getNxmNxArpSha();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc1Grouping arg) {
        this._nxmNxNshc1 = arg.getNxmNxNshc1();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshFlagsGrouping arg) {
        this._nxmNxNshFlags = arg.getNxmNxNshFlags();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIcmpTypeGrouping arg) {
        this._nxmOfIcmpType = arg.getNxmOfIcmpType();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpOpGrouping arg) {
        this._nxmOfArpOp = arg.getNxmOfArpOp();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpTpaGrouping arg) {
        this._nxmOfArpTpa = arg.getNxmOfArpTpa();
    }
    public NxAugMatchPacketInMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshMdtypeGrouping arg) {
        this._nxmNxNshMdtype = arg.getNxmNxNshMdtype();
    }

    public NxAugMatchPacketInMessageBuilder(NxAugMatchPacketInMessage base) {
        this._nxmNxArpSha = base.getNxmNxArpSha();
        this._nxmNxArpTha = base.getNxmNxArpTha();
        this._nxmNxCtMark = base.getNxmNxCtMark();
        this._nxmNxCtState = base.getNxmNxCtState();
        this._nxmNxCtTpDst = base.getNxmNxCtTpDst();
        this._nxmNxCtTpSrc = base.getNxmNxCtTpSrc();
        this._nxmNxCtZone = base.getNxmNxCtZone();
        this._nxmNxNshFlags = base.getNxmNxNshFlags();
        this._nxmNxNshMdtype = base.getNxmNxNshMdtype();
        this._nxmNxNshNp = base.getNxmNxNshNp();
        this._nxmNxNshTtl = base.getNxmNxNshTtl();
        this._nxmNxNshc1 = base.getNxmNxNshc1();
        this._nxmNxNshc2 = base.getNxmNxNshc2();
        this._nxmNxNshc3 = base.getNxmNxNshc3();
        this._nxmNxNshc4 = base.getNxmNxNshc4();
        this._nxmNxNsi = base.getNxmNxNsi();
        this._nxmNxNsp = base.getNxmNxNsp();
        this._nxmNxPktMark = base.getNxmNxPktMark();
        this._nxmNxReg = base.getNxmNxReg();
        this._nxmNxTunId = base.getNxmNxTunId();
        this._nxmNxTunIpv4Dst = base.getNxmNxTunIpv4Dst();
        this._nxmNxTunIpv4Src = base.getNxmNxTunIpv4Src();
        this._nxmOfArpOp = base.getNxmOfArpOp();
        this._nxmOfArpSpa = base.getNxmOfArpSpa();
        this._nxmOfArpTpa = base.getNxmOfArpTpa();
        this._nxmOfEthDst = base.getNxmOfEthDst();
        this._nxmOfEthSrc = base.getNxmOfEthSrc();
        this._nxmOfEthType = base.getNxmOfEthType();
        this._nxmOfIcmpType = base.getNxmOfIcmpType();
        this._nxmOfIpDst = base.getNxmOfIpDst();
        this._nxmOfIpSrc = base.getNxmOfIpSrc();
        this._nxmOfTcpDst = base.getNxmOfTcpDst();
        this._nxmOfTcpSrc = base.getNxmOfTcpSrc();
        this._nxmOfUdpDst = base.getNxmOfUdpDst();
        this._nxmOfUdpSrc = base.getNxmOfUdpSrc();
        this._ofInPort = base.getOfInPort();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIdGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIpv4DstGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshFlagsGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc2Grouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpOpGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpSpaGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.AllMatchesGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtZoneGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthDstGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc4Grouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfTcpDstGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxRegGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfUdpDstGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxArpShaGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthSrcGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtTpDstGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIcmpTypeGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpTpaGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc1Grouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtTpSrcGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshNpGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxPktMarkGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxArpThaGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIpSrcGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtMarkGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc3Grouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfInPortGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthTypeGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIpDstGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNspGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIpv4SrcGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshMdtypeGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtStateGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfUdpSrcGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNsiGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfTcpSrcGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshTtlGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIdGrouping) {
            this._nxmNxTunId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIdGrouping)arg).getNxmNxTunId();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIpv4DstGrouping) {
            this._nxmNxTunIpv4Dst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIpv4DstGrouping)arg).getNxmNxTunIpv4Dst();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshFlagsGrouping) {
            this._nxmNxNshFlags = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshFlagsGrouping)arg).getNxmNxNshFlags();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc2Grouping) {
            this._nxmNxNshc2 = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc2Grouping)arg).getNxmNxNshc2();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpOpGrouping) {
            this._nxmOfArpOp = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpOpGrouping)arg).getNxmOfArpOp();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpSpaGrouping) {
            this._nxmOfArpSpa = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpSpaGrouping)arg).getNxmOfArpSpa();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.AllMatchesGrouping) {
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtZoneGrouping) {
            this._nxmNxCtZone = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtZoneGrouping)arg).getNxmNxCtZone();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthDstGrouping) {
            this._nxmOfEthDst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthDstGrouping)arg).getNxmOfEthDst();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc4Grouping) {
            this._nxmNxNshc4 = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc4Grouping)arg).getNxmNxNshc4();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfTcpDstGrouping) {
            this._nxmOfTcpDst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfTcpDstGrouping)arg).getNxmOfTcpDst();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxRegGrouping) {
            this._nxmNxReg = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxRegGrouping)arg).getNxmNxReg();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfUdpDstGrouping) {
            this._nxmOfUdpDst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfUdpDstGrouping)arg).getNxmOfUdpDst();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxArpShaGrouping) {
            this._nxmNxArpSha = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxArpShaGrouping)arg).getNxmNxArpSha();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthSrcGrouping) {
            this._nxmOfEthSrc = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthSrcGrouping)arg).getNxmOfEthSrc();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtTpDstGrouping) {
            this._nxmNxCtTpDst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtTpDstGrouping)arg).getNxmNxCtTpDst();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIcmpTypeGrouping) {
            this._nxmOfIcmpType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIcmpTypeGrouping)arg).getNxmOfIcmpType();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpTpaGrouping) {
            this._nxmOfArpTpa = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpTpaGrouping)arg).getNxmOfArpTpa();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc1Grouping) {
            this._nxmNxNshc1 = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc1Grouping)arg).getNxmNxNshc1();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtTpSrcGrouping) {
            this._nxmNxCtTpSrc = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtTpSrcGrouping)arg).getNxmNxCtTpSrc();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshNpGrouping) {
            this._nxmNxNshNp = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshNpGrouping)arg).getNxmNxNshNp();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxPktMarkGrouping) {
            this._nxmNxPktMark = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxPktMarkGrouping)arg).getNxmNxPktMark();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxArpThaGrouping) {
            this._nxmNxArpTha = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxArpThaGrouping)arg).getNxmNxArpTha();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIpSrcGrouping) {
            this._nxmOfIpSrc = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIpSrcGrouping)arg).getNxmOfIpSrc();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtMarkGrouping) {
            this._nxmNxCtMark = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtMarkGrouping)arg).getNxmNxCtMark();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc3Grouping) {
            this._nxmNxNshc3 = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc3Grouping)arg).getNxmNxNshc3();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfInPortGrouping) {
            this._ofInPort = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfInPortGrouping)arg).getOfInPort();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthTypeGrouping) {
            this._nxmOfEthType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthTypeGrouping)arg).getNxmOfEthType();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIpDstGrouping) {
            this._nxmOfIpDst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIpDstGrouping)arg).getNxmOfIpDst();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNspGrouping) {
            this._nxmNxNsp = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNspGrouping)arg).getNxmNxNsp();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIpv4SrcGrouping) {
            this._nxmNxTunIpv4Src = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIpv4SrcGrouping)arg).getNxmNxTunIpv4Src();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshMdtypeGrouping) {
            this._nxmNxNshMdtype = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshMdtypeGrouping)arg).getNxmNxNshMdtype();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtStateGrouping) {
            this._nxmNxCtState = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtStateGrouping)arg).getNxmNxCtState();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfUdpSrcGrouping) {
            this._nxmOfUdpSrc = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfUdpSrcGrouping)arg).getNxmOfUdpSrc();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNsiGrouping) {
            this._nxmNxNsi = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNsiGrouping)arg).getNxmNxNsi();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfTcpSrcGrouping) {
            this._nxmOfTcpSrc = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfTcpSrcGrouping)arg).getNxmOfTcpSrc();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshTtlGrouping) {
            this._nxmNxNshTtl = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshTtlGrouping)arg).getNxmNxNshTtl();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIdGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIpv4DstGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshFlagsGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc2Grouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpOpGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpSpaGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.AllMatchesGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtZoneGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthDstGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc4Grouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfTcpDstGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxRegGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfUdpDstGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxArpShaGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthSrcGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtTpDstGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIcmpTypeGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpTpaGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc1Grouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtTpSrcGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshNpGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxPktMarkGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxArpThaGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIpSrcGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtMarkGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc3Grouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfInPortGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthTypeGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIpDstGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNspGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIpv4SrcGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshMdtypeGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtStateGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfUdpSrcGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNsiGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfTcpSrcGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshTtlGrouping]");
    }

    public NxmNxArpSha getNxmNxArpSha() {
        return _nxmNxArpSha;
    }
    
    public NxmNxArpTha getNxmNxArpTha() {
        return _nxmNxArpTha;
    }
    
    public NxmNxCtMark getNxmNxCtMark() {
        return _nxmNxCtMark;
    }
    
    public NxmNxCtState getNxmNxCtState() {
        return _nxmNxCtState;
    }
    
    public NxmNxCtTpDst getNxmNxCtTpDst() {
        return _nxmNxCtTpDst;
    }
    
    public NxmNxCtTpSrc getNxmNxCtTpSrc() {
        return _nxmNxCtTpSrc;
    }
    
    public NxmNxCtZone getNxmNxCtZone() {
        return _nxmNxCtZone;
    }
    
    public NxmNxNshFlags getNxmNxNshFlags() {
        return _nxmNxNshFlags;
    }
    
    public NxmNxNshMdtype getNxmNxNshMdtype() {
        return _nxmNxNshMdtype;
    }
    
    public NxmNxNshNp getNxmNxNshNp() {
        return _nxmNxNshNp;
    }
    
    public NxmNxNshTtl getNxmNxNshTtl() {
        return _nxmNxNshTtl;
    }
    
    public NxmNxNshc1 getNxmNxNshc1() {
        return _nxmNxNshc1;
    }
    
    public NxmNxNshc2 getNxmNxNshc2() {
        return _nxmNxNshc2;
    }
    
    public NxmNxNshc3 getNxmNxNshc3() {
        return _nxmNxNshc3;
    }
    
    public NxmNxNshc4 getNxmNxNshc4() {
        return _nxmNxNshc4;
    }
    
    public NxmNxNsi getNxmNxNsi() {
        return _nxmNxNsi;
    }
    
    public NxmNxNsp getNxmNxNsp() {
        return _nxmNxNsp;
    }
    
    public NxmNxPktMark getNxmNxPktMark() {
        return _nxmNxPktMark;
    }
    
    public NxmNxReg getNxmNxReg() {
        return _nxmNxReg;
    }
    
    public NxmNxTunId getNxmNxTunId() {
        return _nxmNxTunId;
    }
    
    public NxmNxTunIpv4Dst getNxmNxTunIpv4Dst() {
        return _nxmNxTunIpv4Dst;
    }
    
    public NxmNxTunIpv4Src getNxmNxTunIpv4Src() {
        return _nxmNxTunIpv4Src;
    }
    
    public NxmOfArpOp getNxmOfArpOp() {
        return _nxmOfArpOp;
    }
    
    public NxmOfArpSpa getNxmOfArpSpa() {
        return _nxmOfArpSpa;
    }
    
    public NxmOfArpTpa getNxmOfArpTpa() {
        return _nxmOfArpTpa;
    }
    
    public NxmOfEthDst getNxmOfEthDst() {
        return _nxmOfEthDst;
    }
    
    public NxmOfEthSrc getNxmOfEthSrc() {
        return _nxmOfEthSrc;
    }
    
    public NxmOfEthType getNxmOfEthType() {
        return _nxmOfEthType;
    }
    
    public NxmOfIcmpType getNxmOfIcmpType() {
        return _nxmOfIcmpType;
    }
    
    public NxmOfIpDst getNxmOfIpDst() {
        return _nxmOfIpDst;
    }
    
    public NxmOfIpSrc getNxmOfIpSrc() {
        return _nxmOfIpSrc;
    }
    
    public NxmOfTcpDst getNxmOfTcpDst() {
        return _nxmOfTcpDst;
    }
    
    public NxmOfTcpSrc getNxmOfTcpSrc() {
        return _nxmOfTcpSrc;
    }
    
    public NxmOfUdpDst getNxmOfUdpDst() {
        return _nxmOfUdpDst;
    }
    
    public NxmOfUdpSrc getNxmOfUdpSrc() {
        return _nxmOfUdpSrc;
    }
    
    public OfInPort getOfInPort() {
        return _ofInPort;
    }

    
    public NxAugMatchPacketInMessageBuilder setNxmNxArpSha(final NxmNxArpSha value) {
        this._nxmNxArpSha = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmNxArpTha(final NxmNxArpTha value) {
        this._nxmNxArpTha = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmNxCtMark(final NxmNxCtMark value) {
        this._nxmNxCtMark = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmNxCtState(final NxmNxCtState value) {
        this._nxmNxCtState = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmNxCtTpDst(final NxmNxCtTpDst value) {
        this._nxmNxCtTpDst = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmNxCtTpSrc(final NxmNxCtTpSrc value) {
        this._nxmNxCtTpSrc = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmNxCtZone(final NxmNxCtZone value) {
        this._nxmNxCtZone = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmNxNshFlags(final NxmNxNshFlags value) {
        this._nxmNxNshFlags = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmNxNshMdtype(final NxmNxNshMdtype value) {
        this._nxmNxNshMdtype = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmNxNshNp(final NxmNxNshNp value) {
        this._nxmNxNshNp = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmNxNshTtl(final NxmNxNshTtl value) {
        this._nxmNxNshTtl = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmNxNshc1(final NxmNxNshc1 value) {
        this._nxmNxNshc1 = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmNxNshc2(final NxmNxNshc2 value) {
        this._nxmNxNshc2 = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmNxNshc3(final NxmNxNshc3 value) {
        this._nxmNxNshc3 = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmNxNshc4(final NxmNxNshc4 value) {
        this._nxmNxNshc4 = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmNxNsi(final NxmNxNsi value) {
        this._nxmNxNsi = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmNxNsp(final NxmNxNsp value) {
        this._nxmNxNsp = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmNxPktMark(final NxmNxPktMark value) {
        this._nxmNxPktMark = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmNxReg(final NxmNxReg value) {
        this._nxmNxReg = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmNxTunId(final NxmNxTunId value) {
        this._nxmNxTunId = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmNxTunIpv4Dst(final NxmNxTunIpv4Dst value) {
        this._nxmNxTunIpv4Dst = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmNxTunIpv4Src(final NxmNxTunIpv4Src value) {
        this._nxmNxTunIpv4Src = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmOfArpOp(final NxmOfArpOp value) {
        this._nxmOfArpOp = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmOfArpSpa(final NxmOfArpSpa value) {
        this._nxmOfArpSpa = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmOfArpTpa(final NxmOfArpTpa value) {
        this._nxmOfArpTpa = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmOfEthDst(final NxmOfEthDst value) {
        this._nxmOfEthDst = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmOfEthSrc(final NxmOfEthSrc value) {
        this._nxmOfEthSrc = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmOfEthType(final NxmOfEthType value) {
        this._nxmOfEthType = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmOfIcmpType(final NxmOfIcmpType value) {
        this._nxmOfIcmpType = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmOfIpDst(final NxmOfIpDst value) {
        this._nxmOfIpDst = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmOfIpSrc(final NxmOfIpSrc value) {
        this._nxmOfIpSrc = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmOfTcpDst(final NxmOfTcpDst value) {
        this._nxmOfTcpDst = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmOfTcpSrc(final NxmOfTcpSrc value) {
        this._nxmOfTcpSrc = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmOfUdpDst(final NxmOfUdpDst value) {
        this._nxmOfUdpDst = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setNxmOfUdpSrc(final NxmOfUdpSrc value) {
        this._nxmOfUdpSrc = value;
        return this;
    }
    
    public NxAugMatchPacketInMessageBuilder setOfInPort(final OfInPort value) {
        this._ofInPort = value;
        return this;
    }
    

    @Override
    public NxAugMatchPacketInMessage build() {
        return new NxAugMatchPacketInMessageImpl(this);
    }

    private static final class NxAugMatchPacketInMessageImpl
        implements NxAugMatchPacketInMessage {
    
        private final NxmNxArpSha _nxmNxArpSha;
        private final NxmNxArpTha _nxmNxArpTha;
        private final NxmNxCtMark _nxmNxCtMark;
        private final NxmNxCtState _nxmNxCtState;
        private final NxmNxCtTpDst _nxmNxCtTpDst;
        private final NxmNxCtTpSrc _nxmNxCtTpSrc;
        private final NxmNxCtZone _nxmNxCtZone;
        private final NxmNxNshFlags _nxmNxNshFlags;
        private final NxmNxNshMdtype _nxmNxNshMdtype;
        private final NxmNxNshNp _nxmNxNshNp;
        private final NxmNxNshTtl _nxmNxNshTtl;
        private final NxmNxNshc1 _nxmNxNshc1;
        private final NxmNxNshc2 _nxmNxNshc2;
        private final NxmNxNshc3 _nxmNxNshc3;
        private final NxmNxNshc4 _nxmNxNshc4;
        private final NxmNxNsi _nxmNxNsi;
        private final NxmNxNsp _nxmNxNsp;
        private final NxmNxPktMark _nxmNxPktMark;
        private final NxmNxReg _nxmNxReg;
        private final NxmNxTunId _nxmNxTunId;
        private final NxmNxTunIpv4Dst _nxmNxTunIpv4Dst;
        private final NxmNxTunIpv4Src _nxmNxTunIpv4Src;
        private final NxmOfArpOp _nxmOfArpOp;
        private final NxmOfArpSpa _nxmOfArpSpa;
        private final NxmOfArpTpa _nxmOfArpTpa;
        private final NxmOfEthDst _nxmOfEthDst;
        private final NxmOfEthSrc _nxmOfEthSrc;
        private final NxmOfEthType _nxmOfEthType;
        private final NxmOfIcmpType _nxmOfIcmpType;
        private final NxmOfIpDst _nxmOfIpDst;
        private final NxmOfIpSrc _nxmOfIpSrc;
        private final NxmOfTcpDst _nxmOfTcpDst;
        private final NxmOfTcpSrc _nxmOfTcpSrc;
        private final NxmOfUdpDst _nxmOfUdpDst;
        private final NxmOfUdpSrc _nxmOfUdpSrc;
        private final OfInPort _ofInPort;
    
        NxAugMatchPacketInMessageImpl(NxAugMatchPacketInMessageBuilder base) {
            this._nxmNxArpSha = base.getNxmNxArpSha();
            this._nxmNxArpTha = base.getNxmNxArpTha();
            this._nxmNxCtMark = base.getNxmNxCtMark();
            this._nxmNxCtState = base.getNxmNxCtState();
            this._nxmNxCtTpDst = base.getNxmNxCtTpDst();
            this._nxmNxCtTpSrc = base.getNxmNxCtTpSrc();
            this._nxmNxCtZone = base.getNxmNxCtZone();
            this._nxmNxNshFlags = base.getNxmNxNshFlags();
            this._nxmNxNshMdtype = base.getNxmNxNshMdtype();
            this._nxmNxNshNp = base.getNxmNxNshNp();
            this._nxmNxNshTtl = base.getNxmNxNshTtl();
            this._nxmNxNshc1 = base.getNxmNxNshc1();
            this._nxmNxNshc2 = base.getNxmNxNshc2();
            this._nxmNxNshc3 = base.getNxmNxNshc3();
            this._nxmNxNshc4 = base.getNxmNxNshc4();
            this._nxmNxNsi = base.getNxmNxNsi();
            this._nxmNxNsp = base.getNxmNxNsp();
            this._nxmNxPktMark = base.getNxmNxPktMark();
            this._nxmNxReg = base.getNxmNxReg();
            this._nxmNxTunId = base.getNxmNxTunId();
            this._nxmNxTunIpv4Dst = base.getNxmNxTunIpv4Dst();
            this._nxmNxTunIpv4Src = base.getNxmNxTunIpv4Src();
            this._nxmOfArpOp = base.getNxmOfArpOp();
            this._nxmOfArpSpa = base.getNxmOfArpSpa();
            this._nxmOfArpTpa = base.getNxmOfArpTpa();
            this._nxmOfEthDst = base.getNxmOfEthDst();
            this._nxmOfEthSrc = base.getNxmOfEthSrc();
            this._nxmOfEthType = base.getNxmOfEthType();
            this._nxmOfIcmpType = base.getNxmOfIcmpType();
            this._nxmOfIpDst = base.getNxmOfIpDst();
            this._nxmOfIpSrc = base.getNxmOfIpSrc();
            this._nxmOfTcpDst = base.getNxmOfTcpDst();
            this._nxmOfTcpSrc = base.getNxmOfTcpSrc();
            this._nxmOfUdpDst = base.getNxmOfUdpDst();
            this._nxmOfUdpSrc = base.getNxmOfUdpSrc();
            this._ofInPort = base.getOfInPort();
        }
    
        @Override
        public NxmNxArpSha getNxmNxArpSha() {
            return _nxmNxArpSha;
        }
        
        @Override
        public NxmNxArpTha getNxmNxArpTha() {
            return _nxmNxArpTha;
        }
        
        @Override
        public NxmNxCtMark getNxmNxCtMark() {
            return _nxmNxCtMark;
        }
        
        @Override
        public NxmNxCtState getNxmNxCtState() {
            return _nxmNxCtState;
        }
        
        @Override
        public NxmNxCtTpDst getNxmNxCtTpDst() {
            return _nxmNxCtTpDst;
        }
        
        @Override
        public NxmNxCtTpSrc getNxmNxCtTpSrc() {
            return _nxmNxCtTpSrc;
        }
        
        @Override
        public NxmNxCtZone getNxmNxCtZone() {
            return _nxmNxCtZone;
        }
        
        @Override
        public NxmNxNshFlags getNxmNxNshFlags() {
            return _nxmNxNshFlags;
        }
        
        @Override
        public NxmNxNshMdtype getNxmNxNshMdtype() {
            return _nxmNxNshMdtype;
        }
        
        @Override
        public NxmNxNshNp getNxmNxNshNp() {
            return _nxmNxNshNp;
        }
        
        @Override
        public NxmNxNshTtl getNxmNxNshTtl() {
            return _nxmNxNshTtl;
        }
        
        @Override
        public NxmNxNshc1 getNxmNxNshc1() {
            return _nxmNxNshc1;
        }
        
        @Override
        public NxmNxNshc2 getNxmNxNshc2() {
            return _nxmNxNshc2;
        }
        
        @Override
        public NxmNxNshc3 getNxmNxNshc3() {
            return _nxmNxNshc3;
        }
        
        @Override
        public NxmNxNshc4 getNxmNxNshc4() {
            return _nxmNxNshc4;
        }
        
        @Override
        public NxmNxNsi getNxmNxNsi() {
            return _nxmNxNsi;
        }
        
        @Override
        public NxmNxNsp getNxmNxNsp() {
            return _nxmNxNsp;
        }
        
        @Override
        public NxmNxPktMark getNxmNxPktMark() {
            return _nxmNxPktMark;
        }
        
        @Override
        public NxmNxReg getNxmNxReg() {
            return _nxmNxReg;
        }
        
        @Override
        public NxmNxTunId getNxmNxTunId() {
            return _nxmNxTunId;
        }
        
        @Override
        public NxmNxTunIpv4Dst getNxmNxTunIpv4Dst() {
            return _nxmNxTunIpv4Dst;
        }
        
        @Override
        public NxmNxTunIpv4Src getNxmNxTunIpv4Src() {
            return _nxmNxTunIpv4Src;
        }
        
        @Override
        public NxmOfArpOp getNxmOfArpOp() {
            return _nxmOfArpOp;
        }
        
        @Override
        public NxmOfArpSpa getNxmOfArpSpa() {
            return _nxmOfArpSpa;
        }
        
        @Override
        public NxmOfArpTpa getNxmOfArpTpa() {
            return _nxmOfArpTpa;
        }
        
        @Override
        public NxmOfEthDst getNxmOfEthDst() {
            return _nxmOfEthDst;
        }
        
        @Override
        public NxmOfEthSrc getNxmOfEthSrc() {
            return _nxmOfEthSrc;
        }
        
        @Override
        public NxmOfEthType getNxmOfEthType() {
            return _nxmOfEthType;
        }
        
        @Override
        public NxmOfIcmpType getNxmOfIcmpType() {
            return _nxmOfIcmpType;
        }
        
        @Override
        public NxmOfIpDst getNxmOfIpDst() {
            return _nxmOfIpDst;
        }
        
        @Override
        public NxmOfIpSrc getNxmOfIpSrc() {
            return _nxmOfIpSrc;
        }
        
        @Override
        public NxmOfTcpDst getNxmOfTcpDst() {
            return _nxmOfTcpDst;
        }
        
        @Override
        public NxmOfTcpSrc getNxmOfTcpSrc() {
            return _nxmOfTcpSrc;
        }
        
        @Override
        public NxmOfUdpDst getNxmOfUdpDst() {
            return _nxmOfUdpDst;
        }
        
        @Override
        public NxmOfUdpSrc getNxmOfUdpSrc() {
            return _nxmOfUdpSrc;
        }
        
        @Override
        public OfInPort getOfInPort() {
            return _ofInPort;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxmNxArpSha);
            result = prime * result + Objects.hashCode(_nxmNxArpTha);
            result = prime * result + Objects.hashCode(_nxmNxCtMark);
            result = prime * result + Objects.hashCode(_nxmNxCtState);
            result = prime * result + Objects.hashCode(_nxmNxCtTpDst);
            result = prime * result + Objects.hashCode(_nxmNxCtTpSrc);
            result = prime * result + Objects.hashCode(_nxmNxCtZone);
            result = prime * result + Objects.hashCode(_nxmNxNshFlags);
            result = prime * result + Objects.hashCode(_nxmNxNshMdtype);
            result = prime * result + Objects.hashCode(_nxmNxNshNp);
            result = prime * result + Objects.hashCode(_nxmNxNshTtl);
            result = prime * result + Objects.hashCode(_nxmNxNshc1);
            result = prime * result + Objects.hashCode(_nxmNxNshc2);
            result = prime * result + Objects.hashCode(_nxmNxNshc3);
            result = prime * result + Objects.hashCode(_nxmNxNshc4);
            result = prime * result + Objects.hashCode(_nxmNxNsi);
            result = prime * result + Objects.hashCode(_nxmNxNsp);
            result = prime * result + Objects.hashCode(_nxmNxPktMark);
            result = prime * result + Objects.hashCode(_nxmNxReg);
            result = prime * result + Objects.hashCode(_nxmNxTunId);
            result = prime * result + Objects.hashCode(_nxmNxTunIpv4Dst);
            result = prime * result + Objects.hashCode(_nxmNxTunIpv4Src);
            result = prime * result + Objects.hashCode(_nxmOfArpOp);
            result = prime * result + Objects.hashCode(_nxmOfArpSpa);
            result = prime * result + Objects.hashCode(_nxmOfArpTpa);
            result = prime * result + Objects.hashCode(_nxmOfEthDst);
            result = prime * result + Objects.hashCode(_nxmOfEthSrc);
            result = prime * result + Objects.hashCode(_nxmOfEthType);
            result = prime * result + Objects.hashCode(_nxmOfIcmpType);
            result = prime * result + Objects.hashCode(_nxmOfIpDst);
            result = prime * result + Objects.hashCode(_nxmOfIpSrc);
            result = prime * result + Objects.hashCode(_nxmOfTcpDst);
            result = prime * result + Objects.hashCode(_nxmOfTcpSrc);
            result = prime * result + Objects.hashCode(_nxmOfUdpDst);
            result = prime * result + Objects.hashCode(_nxmOfUdpSrc);
            result = prime * result + Objects.hashCode(_ofInPort);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxAugMatchPacketInMessage.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            NxAugMatchPacketInMessage other = (NxAugMatchPacketInMessage)obj;
            if (!Objects.equals(_nxmNxArpSha, other.getNxmNxArpSha())) {
                return false;
            }
            if (!Objects.equals(_nxmNxArpTha, other.getNxmNxArpTha())) {
                return false;
            }
            if (!Objects.equals(_nxmNxCtMark, other.getNxmNxCtMark())) {
                return false;
            }
            if (!Objects.equals(_nxmNxCtState, other.getNxmNxCtState())) {
                return false;
            }
            if (!Objects.equals(_nxmNxCtTpDst, other.getNxmNxCtTpDst())) {
                return false;
            }
            if (!Objects.equals(_nxmNxCtTpSrc, other.getNxmNxCtTpSrc())) {
                return false;
            }
            if (!Objects.equals(_nxmNxCtZone, other.getNxmNxCtZone())) {
                return false;
            }
            if (!Objects.equals(_nxmNxNshFlags, other.getNxmNxNshFlags())) {
                return false;
            }
            if (!Objects.equals(_nxmNxNshMdtype, other.getNxmNxNshMdtype())) {
                return false;
            }
            if (!Objects.equals(_nxmNxNshNp, other.getNxmNxNshNp())) {
                return false;
            }
            if (!Objects.equals(_nxmNxNshTtl, other.getNxmNxNshTtl())) {
                return false;
            }
            if (!Objects.equals(_nxmNxNshc1, other.getNxmNxNshc1())) {
                return false;
            }
            if (!Objects.equals(_nxmNxNshc2, other.getNxmNxNshc2())) {
                return false;
            }
            if (!Objects.equals(_nxmNxNshc3, other.getNxmNxNshc3())) {
                return false;
            }
            if (!Objects.equals(_nxmNxNshc4, other.getNxmNxNshc4())) {
                return false;
            }
            if (!Objects.equals(_nxmNxNsi, other.getNxmNxNsi())) {
                return false;
            }
            if (!Objects.equals(_nxmNxNsp, other.getNxmNxNsp())) {
                return false;
            }
            if (!Objects.equals(_nxmNxPktMark, other.getNxmNxPktMark())) {
                return false;
            }
            if (!Objects.equals(_nxmNxReg, other.getNxmNxReg())) {
                return false;
            }
            if (!Objects.equals(_nxmNxTunId, other.getNxmNxTunId())) {
                return false;
            }
            if (!Objects.equals(_nxmNxTunIpv4Dst, other.getNxmNxTunIpv4Dst())) {
                return false;
            }
            if (!Objects.equals(_nxmNxTunIpv4Src, other.getNxmNxTunIpv4Src())) {
                return false;
            }
            if (!Objects.equals(_nxmOfArpOp, other.getNxmOfArpOp())) {
                return false;
            }
            if (!Objects.equals(_nxmOfArpSpa, other.getNxmOfArpSpa())) {
                return false;
            }
            if (!Objects.equals(_nxmOfArpTpa, other.getNxmOfArpTpa())) {
                return false;
            }
            if (!Objects.equals(_nxmOfEthDst, other.getNxmOfEthDst())) {
                return false;
            }
            if (!Objects.equals(_nxmOfEthSrc, other.getNxmOfEthSrc())) {
                return false;
            }
            if (!Objects.equals(_nxmOfEthType, other.getNxmOfEthType())) {
                return false;
            }
            if (!Objects.equals(_nxmOfIcmpType, other.getNxmOfIcmpType())) {
                return false;
            }
            if (!Objects.equals(_nxmOfIpDst, other.getNxmOfIpDst())) {
                return false;
            }
            if (!Objects.equals(_nxmOfIpSrc, other.getNxmOfIpSrc())) {
                return false;
            }
            if (!Objects.equals(_nxmOfTcpDst, other.getNxmOfTcpDst())) {
                return false;
            }
            if (!Objects.equals(_nxmOfTcpSrc, other.getNxmOfTcpSrc())) {
                return false;
            }
            if (!Objects.equals(_nxmOfUdpDst, other.getNxmOfUdpDst())) {
                return false;
            }
            if (!Objects.equals(_nxmOfUdpSrc, other.getNxmOfUdpSrc())) {
                return false;
            }
            if (!Objects.equals(_ofInPort, other.getOfInPort())) {
                return false;
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxAugMatchPacketInMessage");
            CodeHelpers.appendValue(helper, "_nxmNxArpSha", _nxmNxArpSha);
            CodeHelpers.appendValue(helper, "_nxmNxArpTha", _nxmNxArpTha);
            CodeHelpers.appendValue(helper, "_nxmNxCtMark", _nxmNxCtMark);
            CodeHelpers.appendValue(helper, "_nxmNxCtState", _nxmNxCtState);
            CodeHelpers.appendValue(helper, "_nxmNxCtTpDst", _nxmNxCtTpDst);
            CodeHelpers.appendValue(helper, "_nxmNxCtTpSrc", _nxmNxCtTpSrc);
            CodeHelpers.appendValue(helper, "_nxmNxCtZone", _nxmNxCtZone);
            CodeHelpers.appendValue(helper, "_nxmNxNshFlags", _nxmNxNshFlags);
            CodeHelpers.appendValue(helper, "_nxmNxNshMdtype", _nxmNxNshMdtype);
            CodeHelpers.appendValue(helper, "_nxmNxNshNp", _nxmNxNshNp);
            CodeHelpers.appendValue(helper, "_nxmNxNshTtl", _nxmNxNshTtl);
            CodeHelpers.appendValue(helper, "_nxmNxNshc1", _nxmNxNshc1);
            CodeHelpers.appendValue(helper, "_nxmNxNshc2", _nxmNxNshc2);
            CodeHelpers.appendValue(helper, "_nxmNxNshc3", _nxmNxNshc3);
            CodeHelpers.appendValue(helper, "_nxmNxNshc4", _nxmNxNshc4);
            CodeHelpers.appendValue(helper, "_nxmNxNsi", _nxmNxNsi);
            CodeHelpers.appendValue(helper, "_nxmNxNsp", _nxmNxNsp);
            CodeHelpers.appendValue(helper, "_nxmNxPktMark", _nxmNxPktMark);
            CodeHelpers.appendValue(helper, "_nxmNxReg", _nxmNxReg);
            CodeHelpers.appendValue(helper, "_nxmNxTunId", _nxmNxTunId);
            CodeHelpers.appendValue(helper, "_nxmNxTunIpv4Dst", _nxmNxTunIpv4Dst);
            CodeHelpers.appendValue(helper, "_nxmNxTunIpv4Src", _nxmNxTunIpv4Src);
            CodeHelpers.appendValue(helper, "_nxmOfArpOp", _nxmOfArpOp);
            CodeHelpers.appendValue(helper, "_nxmOfArpSpa", _nxmOfArpSpa);
            CodeHelpers.appendValue(helper, "_nxmOfArpTpa", _nxmOfArpTpa);
            CodeHelpers.appendValue(helper, "_nxmOfEthDst", _nxmOfEthDst);
            CodeHelpers.appendValue(helper, "_nxmOfEthSrc", _nxmOfEthSrc);
            CodeHelpers.appendValue(helper, "_nxmOfEthType", _nxmOfEthType);
            CodeHelpers.appendValue(helper, "_nxmOfIcmpType", _nxmOfIcmpType);
            CodeHelpers.appendValue(helper, "_nxmOfIpDst", _nxmOfIpDst);
            CodeHelpers.appendValue(helper, "_nxmOfIpSrc", _nxmOfIpSrc);
            CodeHelpers.appendValue(helper, "_nxmOfTcpDst", _nxmOfTcpDst);
            CodeHelpers.appendValue(helper, "_nxmOfTcpSrc", _nxmOfTcpSrc);
            CodeHelpers.appendValue(helper, "_nxmOfUdpDst", _nxmOfUdpDst);
            CodeHelpers.appendValue(helper, "_nxmOfUdpSrc", _nxmOfUdpSrc);
            CodeHelpers.appendValue(helper, "_ofInPort", _ofInPort);
            return helper.toString();
        }
    }
}
