/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.set.nsp.grouping;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.set.nsp.grouping.NxSetNsp;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxSetNspBuilder
implements Builder<NxSetNsp> {
    private Long _nsp;
    Map<Class<? extends Augmentation<NxSetNsp>>, Augmentation<NxSetNsp>> augmentation = Collections.emptyMap();

    public NxSetNspBuilder() {
    }

    public NxSetNspBuilder(NxSetNsp base) {
        AugmentationHolder casted;
        this._nsp = base.getNsp();
        if (base instanceof NxSetNspImpl) {
            NxSetNspImpl impl = (NxSetNspImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxSetNsp>>, Augmentation<NxSetNsp>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxSetNsp>>, Augmentation<NxSetNsp>>(casted.augmentations());
        }
    }

    public Long getNsp() {
        return this._nsp;
    }

    public <E extends Augmentation<NxSetNsp>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkNspRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public NxSetNspBuilder setNsp(Long value) {
        if (value != null) {
            NxSetNspBuilder.checkNspRange(value);
        }
        this._nsp = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _nsp_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
        return ret;
    }

    public NxSetNspBuilder addAugmentation(Class<? extends Augmentation<NxSetNsp>> augmentationType, Augmentation<NxSetNsp> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxSetNsp>>, Augmentation<NxSetNsp>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NxSetNspBuilder removeAugmentation(Class<? extends Augmentation<NxSetNsp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxSetNsp build() {
        return new NxSetNspImpl(this);
    }

    private static final class NxSetNspImpl
    implements NxSetNsp {
        private final Long _nsp;
        private Map<Class<? extends Augmentation<NxSetNsp>>, Augmentation<NxSetNsp>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NxSetNsp> getImplementedInterface() {
            return NxSetNsp.class;
        }

        private NxSetNspImpl(NxSetNspBuilder base) {
            this._nsp = base.getNsp();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NxSetNsp>>, Augmentation<NxSetNsp>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NxSetNsp>>, Augmentation<NxSetNsp>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getNsp() {
            return this._nsp;
        }

        public <E extends Augmentation<NxSetNsp>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._nsp == null ? 0 : this._nsp.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxSetNsp.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxSetNsp other = (NxSetNsp)obj;
            if (this._nsp == null ? other.getNsp() != null : !this._nsp.equals(other.getNsp())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxSetNspImpl otherImpl = (NxSetNspImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxSetNsp>>, Augmentation<NxSetNsp>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("NxSetNsp [");
            boolean first = true;
            if (this._nsp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nsp=");
                builder.append(this._nsp);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

