/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.set.nsi.grouping;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.set.nsi.grouping.NxSetNsi;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxSetNsiBuilder
implements Builder<NxSetNsi> {
    private Short _nsi;
    Map<Class<? extends Augmentation<NxSetNsi>>, Augmentation<NxSetNsi>> augmentation = Collections.emptyMap();

    public NxSetNsiBuilder() {
    }

    public NxSetNsiBuilder(NxSetNsi base) {
        AugmentationHolder casted;
        this._nsi = base.getNsi();
        if (base instanceof NxSetNsiImpl) {
            NxSetNsiImpl impl = (NxSetNsiImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxSetNsi>>, Augmentation<NxSetNsi>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxSetNsi>>, Augmentation<NxSetNsi>>(casted.augmentations());
        }
    }

    public Short getNsi() {
        return this._nsi;
    }

    public <E extends Augmentation<NxSetNsi>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkNsiRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public NxSetNsiBuilder setNsi(Short value) {
        if (value != null) {
            NxSetNsiBuilder.checkNsiRange(value);
        }
        this._nsi = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _nsi_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    public NxSetNsiBuilder addAugmentation(Class<? extends Augmentation<NxSetNsi>> augmentationType, Augmentation<NxSetNsi> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxSetNsi>>, Augmentation<NxSetNsi>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NxSetNsiBuilder removeAugmentation(Class<? extends Augmentation<NxSetNsi>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxSetNsi build() {
        return new NxSetNsiImpl(this);
    }

    private static final class NxSetNsiImpl
    implements NxSetNsi {
        private final Short _nsi;
        private Map<Class<? extends Augmentation<NxSetNsi>>, Augmentation<NxSetNsi>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NxSetNsi> getImplementedInterface() {
            return NxSetNsi.class;
        }

        private NxSetNsiImpl(NxSetNsiBuilder base) {
            this._nsi = base.getNsi();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NxSetNsi>>, Augmentation<NxSetNsi>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NxSetNsi>>, Augmentation<NxSetNsi>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getNsi() {
            return this._nsi;
        }

        public <E extends Augmentation<NxSetNsi>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._nsi == null ? 0 : this._nsi.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxSetNsi.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxSetNsi other = (NxSetNsi)obj;
            if (this._nsi == null ? other.getNsi() != null : !this._nsi.equals(other.getNsi())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxSetNsiImpl otherImpl = (NxSetNsiImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxSetNsi>>, Augmentation<NxSetNsi>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("NxSetNsi [");
            boolean first = true;
            if (this._nsi != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nsi=");
                builder.append(this._nsi);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

