/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.move.grouping.nx.reg.move;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.RangeGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.SrcChoiceGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.move.grouping.nx.reg.move.Src;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.SrcChoice;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SrcBuilder
implements Builder<Src> {
    private Integer _end;
    private SrcChoice _srcChoice;
    private Integer _start;
    Map<Class<? extends Augmentation<Src>>, Augmentation<Src>> augmentation = Collections.emptyMap();

    public SrcBuilder() {
    }

    public SrcBuilder(RangeGrouping arg) {
        this._start = arg.getStart();
        this._end = arg.getEnd();
    }

    public SrcBuilder(SrcChoiceGrouping arg) {
        this._srcChoice = arg.getSrcChoice();
    }

    public SrcBuilder(Src base) {
        AugmentationHolder casted;
        this._end = base.getEnd();
        this._srcChoice = base.getSrcChoice();
        this._start = base.getStart();
        if (base instanceof SrcImpl) {
            SrcImpl impl = (SrcImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Src>>, Augmentation<Src>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Src>>, Augmentation<Src>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof RangeGrouping) {
            this._start = ((RangeGrouping)arg).getStart();
            this._end = ((RangeGrouping)arg).getEnd();
            isValidArg = true;
        }
        if (arg instanceof SrcChoiceGrouping) {
            this._srcChoice = ((SrcChoiceGrouping)arg).getSrcChoice();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.RangeGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.SrcChoiceGrouping] \nbut was: " + arg);
        }
    }

    public Integer getEnd() {
        return this._end;
    }

    public SrcChoice getSrcChoice() {
        return this._srcChoice;
    }

    public Integer getStart() {
        return this._start;
    }

    public <E extends Augmentation<Src>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkEndRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public SrcBuilder setEnd(Integer value) {
        if (value != null) {
            SrcBuilder.checkEndRange(value);
        }
        this._end = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _end_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    public SrcBuilder setSrcChoice(SrcChoice value) {
        this._srcChoice = value;
        return this;
    }

    private static void checkStartRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public SrcBuilder setStart(Integer value) {
        if (value != null) {
            SrcBuilder.checkStartRange(value);
        }
        this._start = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _start_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    public SrcBuilder addAugmentation(Class<? extends Augmentation<Src>> augmentationType, Augmentation<Src> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Src>>, Augmentation<Src>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public SrcBuilder removeAugmentation(Class<? extends Augmentation<Src>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Src build() {
        return new SrcImpl(this);
    }

    private static final class SrcImpl
    implements Src {
        private final Integer _end;
        private final SrcChoice _srcChoice;
        private final Integer _start;
        private Map<Class<? extends Augmentation<Src>>, Augmentation<Src>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Src> getImplementedInterface() {
            return Src.class;
        }

        private SrcImpl(SrcBuilder base) {
            this._end = base.getEnd();
            this._srcChoice = base.getSrcChoice();
            this._start = base.getStart();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Src>>, Augmentation<Src>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Src>>, Augmentation<Src>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getEnd() {
            return this._end;
        }

        @Override
        public SrcChoice getSrcChoice() {
            return this._srcChoice;
        }

        @Override
        public Integer getStart() {
            return this._start;
        }

        public <E extends Augmentation<Src>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._end == null ? 0 : this._end.hashCode());
            result = 31 * result + (this._srcChoice == null ? 0 : this._srcChoice.hashCode());
            result = 31 * result + (this._start == null ? 0 : this._start.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Src.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Src other = (Src)obj;
            if (this._end == null ? other.getEnd() != null : !this._end.equals(other.getEnd())) {
                return false;
            }
            if (this._srcChoice == null ? other.getSrcChoice() != null : !this._srcChoice.equals(other.getSrcChoice())) {
                return false;
            }
            if (this._start == null ? other.getStart() != null : !this._start.equals(other.getStart())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SrcImpl otherImpl = (SrcImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Src>>, Augmentation<Src>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Src [");
            boolean first = true;
            if (this._end != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_end=");
                builder.append(this._end);
            }
            if (this._srcChoice != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcChoice=");
                builder.append(this._srcChoice);
            }
            if (this._start != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_start=");
                builder.append(this._start);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

