/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.eth.type.grouping;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.eth.type.grouping.NxmOfEthType;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxmOfEthTypeBuilder {
    private Integer _value;
    private static List<Range<BigInteger>> _value_range;
    Map<Class<? extends Augmentation<NxmOfEthType>>, Augmentation<NxmOfEthType>> augmentation = new HashMap<Class<? extends Augmentation<NxmOfEthType>>, Augmentation<NxmOfEthType>>();

    public NxmOfEthTypeBuilder() {
    }

    public NxmOfEthTypeBuilder(NxmOfEthType base) {
        this._value = base.getValue();
        if (base instanceof NxmOfEthTypeImpl) {
            NxmOfEthTypeImpl _impl = (NxmOfEthTypeImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<NxmOfEthType>>, Augmentation<NxmOfEthType>>(_impl.augmentation);
        }
    }

    public Integer getValue() {
        return this._value;
    }

    public <E extends Augmentation<NxmOfEthType>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NxmOfEthTypeBuilder setValue(Integer value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.intValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : NxmOfEthTypeBuilder._value_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _value_range));
            }
        }
        this._value = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _value_range() {
        if (_value_range != null) return _value_range;
        Class<NxmOfEthTypeBuilder> clazz = NxmOfEthTypeBuilder.class;
        synchronized (NxmOfEthTypeBuilder.class) {
            if (_value_range != null) return _value_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
            _value_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _value_range;
        }
    }

    public NxmOfEthTypeBuilder addAugmentation(Class<? extends Augmentation<NxmOfEthType>> augmentationType, Augmentation<NxmOfEthType> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NxmOfEthType build() {
        return new NxmOfEthTypeImpl(this);
    }

    private static final class NxmOfEthTypeImpl
    implements NxmOfEthType {
        private final Integer _value;
        private Map<Class<? extends Augmentation<NxmOfEthType>>, Augmentation<NxmOfEthType>> augmentation = new HashMap<Class<? extends Augmentation<NxmOfEthType>>, Augmentation<NxmOfEthType>>();

        public Class<NxmOfEthType> getImplementedInterface() {
            return NxmOfEthType.class;
        }

        private NxmOfEthTypeImpl(NxmOfEthTypeBuilder base) {
            this._value = base.getValue();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NxmOfEthType>>, Augmentation<NxmOfEthType>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NxmOfEthType>>, Augmentation<NxmOfEthType>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getValue() {
            return this._value;
        }

        public <E extends Augmentation<NxmOfEthType>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._value == null ? 0 : this._value.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmOfEthType.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxmOfEthType other = (NxmOfEthType)obj;
            if (this._value == null ? other.getValue() != null : !this._value.equals(other.getValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxmOfEthTypeImpl otherImpl = (NxmOfEthTypeImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxmOfEthType>>, Augmentation<NxmOfEthType>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("NxmOfEthType [");
            boolean first = true;
            if (this._value != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_value=");
                builder.append(this._value);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

