/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.nx.match.nsp.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.nx.match.nsp.grouping.NspValues;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NspValuesBuilder
implements Builder<NspValues> {
    private Long _nsp;
    Map<Class<? extends Augmentation<NspValues>>, Augmentation<NspValues>> augmentation = Collections.emptyMap();

    public NspValuesBuilder() {
    }

    public NspValuesBuilder(NspValues base) {
        AugmentationHolder casted;
        this._nsp = base.getNsp();
        if (base instanceof NspValuesImpl) {
            NspValuesImpl impl = (NspValuesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NspValues>>, Augmentation<NspValues>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NspValues>>, Augmentation<NspValues>>(casted.augmentations());
        }
    }

    public Long getNsp() {
        return this._nsp;
    }

    public <E extends Augmentation<NspValues>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkNspRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public NspValuesBuilder setNsp(Long value) {
        if (value != null) {
            NspValuesBuilder.checkNspRange(value);
        }
        this._nsp = value;
        return this;
    }

    public NspValuesBuilder addAugmentation(Class<? extends Augmentation<NspValues>> augmentationType, Augmentation<NspValues> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NspValues>>, Augmentation<NspValues>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NspValuesBuilder removeAugmentation(Class<? extends Augmentation<NspValues>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NspValues build() {
        return new NspValuesImpl(this);
    }

    private static final class NspValuesImpl
    implements NspValues {
        private final Long _nsp;
        private Map<Class<? extends Augmentation<NspValues>>, Augmentation<NspValues>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NspValues> getImplementedInterface() {
            return NspValues.class;
        }

        private NspValuesImpl(NspValuesBuilder base) {
            this._nsp = base.getNsp();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NspValues>>, Augmentation<NspValues>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NspValues>>, Augmentation<NspValues>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getNsp() {
            return this._nsp;
        }

        public <E extends Augmentation<NspValues>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._nsp);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NspValues.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NspValues other = (NspValues)obj;
            if (!Objects.equals(this._nsp, other.getNsp())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NspValuesImpl otherImpl = (NspValuesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NspValues>>, Augmentation<NspValues>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("NspValues [");
            boolean first = true;
            if (this._nsp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nsp=");
                builder.append(this._nsp);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

