/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.nx.match.ct.state.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.nx.match.ct.state.grouping.CtStateValues;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class CtStateValuesBuilder
implements Builder<CtStateValues> {
    private Long _ctState;
    private Long _mask;
    Map<Class<? extends Augmentation<CtStateValues>>, Augmentation<CtStateValues>> augmentation = Collections.emptyMap();

    public CtStateValuesBuilder() {
    }

    public CtStateValuesBuilder(CtStateValues base) {
        AugmentationHolder casted;
        this._ctState = base.getCtState();
        this._mask = base.getMask();
        if (base instanceof CtStateValuesImpl) {
            CtStateValuesImpl impl = (CtStateValuesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<CtStateValues>>, Augmentation<CtStateValues>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CtStateValues>>, Augmentation<CtStateValues>>(casted.augmentations());
        }
    }

    public Long getCtState() {
        return this._ctState;
    }

    public Long getMask() {
        return this._mask;
    }

    public <E extends Augmentation<CtStateValues>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkCtStateRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public CtStateValuesBuilder setCtState(Long value) {
        if (value != null) {
            CtStateValuesBuilder.checkCtStateRange(value);
        }
        this._ctState = value;
        return this;
    }

    private static void checkMaskRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public CtStateValuesBuilder setMask(Long value) {
        if (value != null) {
            CtStateValuesBuilder.checkMaskRange(value);
        }
        this._mask = value;
        return this;
    }

    public CtStateValuesBuilder addAugmentation(Class<? extends Augmentation<CtStateValues>> augmentationType, Augmentation<CtStateValues> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CtStateValues>>, Augmentation<CtStateValues>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public CtStateValuesBuilder removeAugmentation(Class<? extends Augmentation<CtStateValues>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public CtStateValues build() {
        return new CtStateValuesImpl(this);
    }

    private static final class CtStateValuesImpl
    implements CtStateValues {
        private final Long _ctState;
        private final Long _mask;
        private Map<Class<? extends Augmentation<CtStateValues>>, Augmentation<CtStateValues>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<CtStateValues> getImplementedInterface() {
            return CtStateValues.class;
        }

        private CtStateValuesImpl(CtStateValuesBuilder base) {
            this._ctState = base.getCtState();
            this._mask = base.getMask();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<CtStateValues>>, Augmentation<CtStateValues>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<CtStateValues>>, Augmentation<CtStateValues>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getCtState() {
            return this._ctState;
        }

        @Override
        public Long getMask() {
            return this._mask;
        }

        public <E extends Augmentation<CtStateValues>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ctState);
            result = 31 * result + Objects.hashCode(this._mask);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!CtStateValues.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            CtStateValues other = (CtStateValues)obj;
            if (!Objects.equals(this._ctState, other.getCtState())) {
                return false;
            }
            if (!Objects.equals(this._mask, other.getMask())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                CtStateValuesImpl otherImpl = (CtStateValuesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<CtStateValues>>, Augmentation<CtStateValues>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("CtStateValues [");
            boolean first = true;
            if (this._ctState != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ctState=");
                builder.append(this._ctState);
            }
            if (this._mask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_mask=");
                builder.append(this._mask);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

